#!/usr/bin/python

"""
Module Bluetooth for Inguma
Copyright (c) 2008 Hugo Teso <hugo.teso@gmail.com>

License is GPL
"""

import sys
try:
    import bluetooth
except:
    print "module bluetooth (pybluez) not found"

from lib.libexploit import CIngumaModule

name = "bluetooth"
brief_description = "A simple bluetooth scanner"
type = "discover" # The type of a module, currently, can only be 'gather', 'exploit', 'discover', 'fuzz' or 'brute'

globals = ['mode', ]

class CBluetooth(CIngumaModule):
    """ The example module. The main class will always starts with the character "C". Any other class will be ignored """

    # Default values
    mode = 'discover'
    target = 'all'

    def help(self):
        """ This is the entry point for info <module> """
        print "mode = <discover|gather>"
        print "       <discover: search for bluetooth devices>"
        print "       <gather: gather services of specified device (target)>"
        print "target = <all|localhost|address>"
        print "         <all: gather services of all devices available>"
        print "         <localhost: scan localhost services>"
        print "         <address: scan specified addres>"

    def run(self):
        """ This is the main entry point of the module """

        if self.mode=='discover':
            print "Searching Bluetooth devices..."
            nearby_devices = bluetooth.discover_devices(lookup_names = True)
            print "found %d devices" % len(nearby_devices)
            for name, addr in nearby_devices:
                print "  %s - %s" % (addr, name)
            return False

        elif self.mode=='gather':
            target = None
            services = bluetooth.find_service(address=self.target)
            if len(services) > 0:
                print "found %d services on %s" % (len(services), self.target)
                print
            else:
                print "no services found"
            
            for svc in services:
                print "Service Name: %s"    % svc["name"]
                print "    Host:        %s" % svc["host"]
                print "    Description: %s" % svc["description"]
                print "    Provided By: %s" % svc["provider"]
                print "    Protocol:    %s" % svc["protocol"]
                print "    channel/PSM: %s" % svc["port"]
                print "    svc classes: %s "% svc["service-classes"]
                print "    profiles:    %s "% svc["profiles"]
                print "    service id:  %s "% svc["service-id"]
                print
            return False

        else:
            print "Mode %s not valid" % (self.mode)
            return False

    def printSummary(self):
        """ If the method run of the module returns True printSummary will called after """
        pass
