﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace AutoSecTools.Components.Threading
{
    public static class Async
    {
        public static void ForEach<T>(T[] elements, Action<T> action)
        {
            var resets = new ManualResetEvent[elements.Length];

            for (int i = 0; i < elements.Length; i++)
            {
                resets[i] = new ManualResetEvent(false);
                var i2 = i;

                ThreadPool.QueueUserWorkItem(x =>
                {
                    action(elements[i2]);

                    resets[i2].Set();
                });
            }

            foreach (var reset in resets)
                reset.WaitOne();
        }
    }
}
