#!/usr/bin/python

# HTExploit - Written by Matias Katz (@matiaskatz)
# Presented at Black Hat US 2012 Conference
# Team Leader: Maximiliano Soler (@maxisoler)
# Homepage: www.htexploit.org

# File 'lib/FullList.py' performs the entire scan on the specified server, using a dictionary file. It then calls the LinkScan module for recursion

import datetime, os, random, sys
import Conn, LinkScan

#Set local variables
files = ""
i = 0
j = 0
tot_iterations = 0
now = datetime.datetime.now()

def Scan(url,verbose,outdir,wordlist):
	global files, i, j, options, repfile, tot_files, tot_iterations
	i = 0
	j = 0
	tot_iterations += 1
	if outdir == None: #If no output directory is specified, a random one is set by the tool
	        rnd = str(random.randint(1, 99999))
	        outdir = os.path.abspath("htexploit-" + rnd.zfill(5)) # Create a variable including a 5-digit random number
	        if verbose > 0:
	                print "[+] Output not specified, setting '" + outdir + "'"
	else:
	        outdir = os.path.abspath(outdir)
	try:
		files = open(wordlist,"r") 
	except:
		print "[-] Unable to open '" + wordlist + "' wordlist file." 
		print "[-] Exiting\n"
		sys.exit()

	#Check if the output directory exists. If not, create it. Then, copy all report resource files into it
	if not os.path.exists(outdir + "/FullList"):
		if verbose > 0:
			print "[+] Creating Output Dir\n"
		try:
			os.makedirs(outdir + "/FullList")
			os.makedirs(outdir + "/res")
		except:
			print "[-] Error creating output directory, do you have permissions?"
			sys.exit("[-] Exiting.\n")

		try:
			# Copy logo PNG file
			origfile = file(os.getcwd() + "/res/reporting/logo.png","r")
			destfile = file(outdir + "/res/logo.png","w")
			destfile.writelines(origfile)
			# Copy CSS file
			origfile = file(os.getcwd() + "/res/reporting/style.css","r")
			destfile = file(outdir + "/res/style.css","w")
			destfile.writelines(origfile)
			repfile = file(outdir + "/HTExploit-FullList.html","w")
			origfile = file(os.getcwd() + "/res/reporting/header.html","r") 
			repfile.writelines(origfile)
			# Insert scan header
			repfile.writelines("<p align='center'><font size=4><b>HTExploit - Full-List Scan Report</b></font></p>")
			repfile.writelines("<h4>Scan date: " + now.strftime("%Y-%m-%d %H:%M") + "</h4>")
			repfile.writelines("<h4>Scanned URL: <a href='" + url + "' target='_blank'>" + url + "</a></h4>")
			repfile.writelines("<table class='bordered'><thead>")
			repfile.writelines("<tr><th>ID</th><th>Name</th></tr></thead>")
		except:
			print "[-] Error creating report files, do you have permissions?"

	#Open the wordlist file and start connecting to the server and trying to retrieve each file listed
	if verbose > 0:
		print "[+] Full Scan started"

	for line in files:
		#Do not download a file more than once
		if os.path.isfile(outdir + "/FullList/" + line.strip() + ".html"):
			if verbose > 1:
				print "[-] File '" + line.strip() + "' has already been downloaded"
				pass
		else:
		        conn_res = Conn.Connect(2,url + "/" + line)
		        if conn_res == 1: #If there's an error in the connection
		                print "[-] Connection error."
				print "[-] Check if URL is valid and target is up and listening on the specified port.\n"
				sys.exit()
		        #elif (conn_res == 404 or conn_res == 501): #If file was not found (exploit didn't work)
			elif (str(conn_res)[:3] <> "200"): #If file was not found (exploit didn't work)
				if verbose > 1:
					print "[-] File '" + line.strip() + "' couldn't be retrieved"
			else:
				i = i + 1 #Variable 'i' counts each file downloaded correctly
				if verbose > 1:
					print "[+] File '" + line.strip() + "' was downloaded"
				#Save the downloaded file as HTML on the output directory
				try:
					outfile = file(outdir + "/FullList/" + line.strip() + ".html","w") #Save the files as HTML files, for easy reading
					outfile.writelines(str(conn_res)[3:]) # Remove the '200' used for verification
					reptfile = file(outdir + "/FullList/rawlist","a") #Save a plain-text list of found files, for other modules
					reptfile.writelines(line.strip() + "\n")	

				except: # If the file name is not accepted by the OS, generate random name
					try:
						outfile = open(outdir + "/LinkScan/file-" + str(i).zfill(8) + ".html", "w")
                        	                outfile.writelines(str(conn_res)[3:]) # Remove the '200' used for verification
                                        	reptfile = file(outdir + "/FullList/rawlist","a") #Save a plain-text list of found files, for other modules
	                                        reptfile.writelines(line.strip() + "\n")
					except:
						pass
						if verbose > 1:
							print "[x] I/O error on writing output file, do you have permissions?"

			j = j + 1 #Variable 'j' counts each file scanned (downloaded or not)

	reptfile = file(outdir + "/FullList/rawlist","a")
	reptfile.writelines("\n") # Append a line break at the end, for the report

	if verbose > 0:
		print 
		print "[+] Full Scan Completed"

	#If i==0 that means there are no new files to download, and so the scan is over
	if i != 0:
		if verbose > 0:
			print "[+] " + str(i) + " files were downloaded, out of " + str(j) + " (" + str(i * 100 / j) + "% success rate)"

		LinkScan.Scan(url,verbose,outdir)
	else:

		#If all files were downloaded and scan is over
		if verbose > 0:
			print "[+] " + str(i) + " files were downloaded. It seems you've downloaded everything you could from this website"

		print "[+] Creating report..."

		#After finishing scan, create final report
		tot_files = 1 #Variable tot_files will contain the total number of files downloaded, during all iterations
		try:
			rawfile = file(outdir + "/FullList/rawlist","r")
			for line in rawfile:
				#repfile = file(outdir + "/res/full-list.html","a")
				repfile.writelines("<TR><TD>")
				repfile.writelines(str(tot_files))
				repfile.writelines("</TD><TD>")
				repfile.writelines("<a href='FullList/" + line.strip() + ".html' target='_blank'>" + line.strip() + "</a><br />")
				repfile.writelines("</TD></TR>")
				tot_files += 1
		except:
			pass

		#Write the footer section of the final report
		origfile = file(os.getcwd() + "/res/reporting/footer.html","r")
		repfile.writelines("\n")
		repfile.writelines(origfile)

		print "[+] Scan completed."
		print "[+]" , tot_files -1 ,"total files were downloaded, after", tot_iterations, "iteration(s)"
		print "[+] The final report file is in '" + outdir + "'\n"
		print "[x] Keep shopping at the HTExploit store! :)\n"
		sys.exit()
