#!/usr/bin/python

# HTExploit - Written by Matias Katz (@matiaskatz)
# Presented at Black Hat US 2012 Conference
# Team Leader: Maximiliano Soler (@maxisoler)
# Homepage: www.htexploit.org

# File 'lib/Detect.py' is the module for quick detection. It detects if the specified server is vulnerable to the exploit or not

import sys
import Conn, FullList

#The default file to detect if vulnerable. Should not be changed
dst_file = "index.php"

#The main scanner engine
def Scan(url,verbose,outdir,wordlist):
	res = Conn.Connect(1,url + dst_file) #Call the Conn module to establish the HTTP connection (First parameter is 1 for just detection)
	if verbose > 1:
		print "[+] Testing '" + url + dst_file + "'...\n"
	if res == 1: #If there is an error in the connection
		print "[-] Connection error."
		print "[-] Check if URL is valid and target is up and listening on the specified port.\n"
		sys.exit()
	else:
		if res == 200: #If the retrieval was OK
			print "[+] " + url + " seems exploitable :)\n"
		else: #If the retrieval failed
			print "[-] " + url + " is probably NOT exploitable :("
			print "[-] You should run the Full Scan module anyway, just in case.\n"

	print "Would you like to run the Full Scan module? [Y/n]:",
	yes = set(['yes','y', 'ye', ''])
	no = set(['no','n'])
	r = None
	while (r == None):
		choice = raw_input().lower()
		if choice in yes:
			FullList.Scan(url,verbose,outdir,wordlist)
			r = 1
		elif choice in no:
			print
			return False
			r = 1
		else:
			print "Please respond with 'yes' or 'no':",
