/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.diff;

import com.sittinglittleduck.DirBuster.diff.Diff;
import com.sittinglittleduck.DirBuster.diff.UnaryPredicate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;

public class DiffPrint {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] slurp(String file) throws IOException {
        BufferedReader rdr = new BufferedReader(new FileReader(file));
        try {
            String line;
            Vector<String> s = new Vector<String>();
            while ((line = rdr.readLine()) != null) {
                s.addElement(line);
            }
            Object[] a = new String[s.size()];
            s.copyInto(a);
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            rdr.close();
        }
    }

    public static void main(String[] argv) throws IOException {
        String filea = argv[argv.length - 2];
        String fileb = argv[argv.length - 1];
        Object[] a = DiffPrint.slurp(filea);
        Object[] b = DiffPrint.slurp(fileb);
        Diff d = new Diff(a, b);
        int style = 110;
        for (int i = 0; i < argv.length - 2; ++i) {
            String f = argv[i];
            if (!f.startsWith("-")) continue;
            block11: for (int j = 1; j < f.length(); ++j) {
                switch (f.charAt(j)) {
                    case 'e': {
                        style = 101;
                        continue block11;
                    }
                    case 'c': {
                        style = 99;
                        continue block11;
                    }
                    case 'u': {
                        style = 117;
                    }
                }
            }
        }
        boolean reverse = style == 101;
        Diff.change script = d.diff_2(reverse);
        if (script == null) {
            System.err.println("No differences");
        } else {
            Base p;
            switch (style) {
                case 101: {
                    p = new EdPrint(a, b);
                    break;
                }
                case 99: {
                    p = new ContextPrint(a, b);
                    break;
                }
                case 117: {
                    p = new UnifiedPrint(a, b);
                    break;
                }
                default: {
                    p = new NormalPrint(a, b);
                }
            }
            p.print_header(filea, fileb);
            p.print_script(script);
        }
    }

    public static class UnifiedPrint
    extends ContextPrint {
        public UnifiedPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        public void print_header(String filea, String fileb) {
            this.print_context_label("---", new File(filea), filea);
            this.print_context_label("+++", new File(fileb), fileb);
        }

        private void print_number_range(int a, int b) {
            if (b < a) {
                this.stringOut.append(b + ",0");
            } else {
                super.print_number_range(',', a, b);
            }
        }

        protected void print_hunk(Diff.change hunk) {
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.first0 = Math.max(this.first0 - this.context, 0);
            this.first1 = Math.max(this.first1 - this.context, 0);
            this.last0 = Math.min(this.last0 + this.context, this.file0.length - 1);
            this.last1 = Math.min(this.last1 + this.context, this.file1.length - 1);
            this.stringOut.append("@@ -");
            this.print_number_range(this.first0, this.last0);
            this.stringOut.append(" +");
            this.print_number_range(this.first1, this.last1);
            this.stringOut.append(" @@");
            this.print_function(this.file0, this.first0);
            this.stringOut.append("\r\n");
            Diff.change next = hunk;
            int i = this.first0;
            int j = this.first1;
            while (i <= this.last0 || j <= this.last1) {
                if (next == null || i < next.line0) {
                    if (i < this.file0.length) {
                        this.stringOut.append(' ');
                        this.stringOut.append(' ');
                        this.print_1_line("", this.file0[i++]);
                    }
                    ++j;
                    continue;
                }
                int k = next.deleted;
                while (k-- > 0) {
                    this.stringOut.append('-');
                    this.stringOut.append('-');
                    this.print_1_line("", this.file0[i++]);
                }
                k = next.inserted;
                while (k-- > 0) {
                    this.stringOut.append('+');
                    this.stringOut.append('+');
                    this.print_1_line("", this.file1[j++]);
                }
                next = next.link;
            }
        }
    }

    public static class ContextPrint
    extends Base {
        protected int context = 3;

        public ContextPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        protected void print_context_label(String mark, File inf, String label) {
            if (label != null) {
                this.stringOut.append(mark + ' ' + label + "\r\n");
            } else if (inf.lastModified() > 0L) {
                this.stringOut.append(mark + ' ' + inf.getPath() + '\t' + new Date(inf.lastModified()) + "\r\n");
            } else {
                this.stringOut.append(mark + ' ' + inf.getPath() + "\r\n");
            }
        }

        public void print_header(String filea, String fileb) {
            this.print_context_label("***", new File(filea), filea);
            this.print_context_label("---", new File(fileb), fileb);
        }

        private String find_function(Object[] lines, int start) {
            return null;
        }

        protected void print_function(Object[] file, int start) {
            String function = this.find_function(this.file0, this.first0);
            if (function != null) {
                this.stringOut.append(" ");
                this.stringOut.append(function.length() < 40 ? function : function.substring(0, 40));
            }
        }

        protected void print_hunk(Diff.change hunk) {
            String prefix;
            int i;
            Diff.change next;
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.first0 = Math.max(this.first0 - this.context, 0);
            this.first1 = Math.max(this.first1 - this.context, 0);
            this.last0 = Math.min(this.last0 + this.context, this.file0.length - 1);
            this.last1 = Math.min(this.last1 + this.context, this.file1.length - 1);
            this.stringOut.append("***************");
            this.print_function(this.file0, this.first0);
            this.stringOut.append("\r\n");
            this.stringOut.append("*** ");
            this.print_number_range(',', this.first0, this.last0);
            this.stringOut.append(" ****\r\n");
            if (this.deletes != 0) {
                next = hunk;
                for (i = this.first0; i <= this.last0; ++i) {
                    while (next != null && next.line0 + next.deleted <= i) {
                        next = next.link;
                    }
                    prefix = " ";
                    if (next != null && next.line0 <= i) {
                        prefix = next.inserted > 0 ? "!" : "-";
                    }
                    this.print_1_line(prefix, this.file0[i]);
                }
            }
            this.stringOut.append("--- ");
            this.print_number_range(',', this.first1, this.last1);
            this.stringOut.append(" ----\r\n");
            if (this.inserts != 0) {
                next = hunk;
                for (i = this.first1; i <= this.last1; ++i) {
                    while (next != null && next.line1 + next.inserted <= i) {
                        next = next.link;
                    }
                    prefix = " ";
                    if (next != null && next.line1 <= i) {
                        prefix = next.deleted > 0 ? "!" : "+";
                    }
                    this.print_1_line(prefix, this.file1[i]);
                }
            }
        }
    }

    public static class EdPrint
    extends Base {
        public EdPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        protected void print_hunk(Diff.change hunk) {
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.print_number_range(',', this.first0, this.last0);
            this.stringOut.append(EdPrint.change_letter(this.inserts, this.deletes) + "\r\n");
            if (this.inserts != 0) {
                boolean inserting = true;
                for (int i = this.first1; i <= this.last1; ++i) {
                    if (!inserting) {
                        this.stringOut.append(i - this.first1 + this.first0 + "a\r\n");
                    }
                    inserting = true;
                    if (".".equals(this.file1[i])) {
                        this.stringOut.append("..\r\n");
                        this.stringOut.append(".\r\n");
                        this.stringOut.append(i - this.first1 + this.first0 + 1 + "s/^\\.\\././" + "\r\n");
                        inserting = false;
                        continue;
                    }
                    this.print_1_line("", this.file1[i]);
                }
                if (inserting) {
                    this.stringOut.append(".\r\n");
                }
            }
        }
    }

    public static class NormalPrint
    extends Base {
        public NormalPrint(Object[] a, Object[] b) {
            super(a, b);
        }

        protected void print_hunk(Diff.change hunk) {
            int i;
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            this.print_number_range(',', this.first0, this.last0);
            this.stringOut.append(NormalPrint.change_letter(this.inserts, this.deletes));
            this.print_number_range(',', this.first1, this.last1);
            this.stringOut.append("\r\n");
            if (this.deletes != 0) {
                for (i = this.first0; i <= this.last0; ++i) {
                    this.print_1_line("< ", this.file0[i]);
                }
            }
            if (this.inserts != 0 && this.deletes != 0) {
                this.stringOut.append("---\r\n");
            }
            if (this.inserts != 0) {
                for (i = this.first1; i <= this.last1; ++i) {
                    this.print_1_line("> ", this.file1[i]);
                }
            }
        }
    }

    public static abstract class Base {
        protected PrintWriter outfile;
        protected StringBuffer stringOut = new StringBuffer();
        protected UnaryPredicate ignore = null;
        protected Object[] file0;
        protected Object[] file1;
        protected int first0;
        protected int last0;
        protected int first1;
        protected int last1;
        protected int deletes;
        protected int inserts;

        public void setOutput(Writer wtr) {
            this.outfile = new PrintWriter(wtr);
        }

        private void setupOutput() {
            if (this.outfile == null) {
                this.outfile = new PrintWriter(new OutputStreamWriter(System.out));
            }
        }

        protected Base(Object[] a, Object[] b) {
            this.file0 = a;
            this.file1 = b;
        }

        public String print_script(Diff.change script) {
            this.setupOutput();
            Diff.change next = script;
            while (next != null) {
                Diff.change t = next;
                Diff.change end = this.hunkfun(next);
                next = end.link;
                end.link = null;
                this.print_hunk(t);
                end.link = next;
            }
            this.outfile.flush();
            return this.stringOut.toString();
        }

        protected Diff.change hunkfun(Diff.change hunk) {
            return hunk;
        }

        protected void analyze_hunk(Diff.change hunk) {
            int l0 = 0;
            int l1 = 0;
            int show_from = 0;
            int show_to = 0;
            boolean nontrivial = this.ignore == null;
            show_to = 0;
            show_from = 0;
            int f0 = hunk.line0;
            int f1 = hunk.line1;
            Diff.change next = hunk;
            while (next != null) {
                int i;
                l0 = next.line0 + next.deleted - 1;
                l1 = next.line1 + next.inserted - 1;
                show_from += next.deleted;
                show_to += next.inserted;
                for (i = next.line0; i <= l0 && !nontrivial; ++i) {
                    if (this.ignore.execute(this.file0[i])) continue;
                    nontrivial = true;
                }
                for (i = next.line1; i <= l1 && !nontrivial; ++i) {
                    if (this.ignore.execute(this.file1[i])) continue;
                    nontrivial = true;
                }
                next = next.link;
            }
            this.first0 = f0;
            this.last0 = l0;
            this.first1 = f1;
            this.last1 = l1;
            if (!nontrivial) {
                show_to = 0;
                show_from = 0;
            }
            this.deletes = show_from;
            this.inserts = show_to;
        }

        protected void print_header(String filea, String fileb) {
            this.setupOutput();
        }

        protected abstract void print_hunk(Diff.change var1);

        protected void print_1_line(String pre, Object linbuf) {
            this.stringOut.append(pre + linbuf.toString() + "\r\n");
        }

        protected void print_number_range(char sepchar, int a, int b) {
            if (++b > ++a) {
                this.stringOut.append("" + a + sepchar + b);
            } else {
                this.stringOut.append(b);
            }
        }

        public static char change_letter(int inserts, int deletes) {
            if (inserts == 0) {
                return 'd';
            }
            if (deletes == 0) {
                return 'a';
            }
            return 'c';
        }
    }
}

