/*
 * Decompiled with CFR 0.152.
 */
package lanchon.multidexlib2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lanchon.multidexlib2.AbstractMultiDexContainer;
import lanchon.multidexlib2.BasicDexEntry;
import lanchon.multidexlib2.DexFileNameComparator;
import lanchon.multidexlib2.DexFileNamer;
import lanchon.multidexlib2.RawDexIO;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;

public class ZipFileDexContainer
extends AbstractMultiDexContainer<DexBackedDexFile> {
    public static boolean isZipFile(File zip) {
        if (!zip.isFile()) {
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(zip);
            zipFile.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public ZipFileDexContainer(File zip, DexFileNamer namer, Opcodes opcodes) throws IOException {
        TreeMap entryMap = new TreeMap(new DexFileNameComparator(namer));
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                DexBackedDexFile dexFile;
                ZipEntry zipEntry = zipEntries.nextElement();
                String entryName = zipEntry.getName();
                if (!namer.isValidName(entryName)) continue;
                try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                    dexFile = RawDexIO.readRawDexFile(inputStream, zipEntry.getSize(), opcodes);
                }
                BasicDexEntry<ZipFileDexContainer, DexBackedDexFile> entry = new BasicDexEntry<ZipFileDexContainer, DexBackedDexFile>(this, entryName, dexFile);
                if (entryMap.put(entryName, entry) == null) continue;
                throw this.duplicateEntryName(entryName);
            }
        }
        this.initialize(entryMap);
    }
}

