/*
 * Decompiled with CFR 0.152.
 */
package lanchon.multidexlib2;

import com.google.common.io.ByteStreamsHack;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import lanchon.multidexlib2.DexIO;
import lanchon.multidexlib2.SingletonDexContainer;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.util.DexUtil;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;

public class RawDexIO {
    private RawDexIO() {
    }

    public static DexBackedDexFile readRawDexFile(File file, Opcodes opcodes, DexIO.Logger logger) throws IOException {
        DexBackedDexFile dexFile = RawDexIO.readRawDexFile(file, opcodes);
        if (logger != null) {
            logger.log(file, SingletonDexContainer.UNDEFINED_ENTRY_NAME, dexFile.getClasses().size());
        }
        return dexFile;
    }

    public static DexBackedDexFile readRawDexFile(File file, Opcodes opcodes) throws IOException {
        byte[] buf = Files.toByteArray(file);
        return RawDexIO.readRawDexFile(buf, 0, opcodes);
    }

    public static DexBackedDexFile readRawDexFile(InputStream inputStream, long expectedSize, Opcodes opcodes) throws IOException {
        byte[] buf = ByteStreamsHack.toByteArray(inputStream, expectedSize);
        return RawDexIO.readRawDexFile(buf, 0, opcodes);
    }

    public static DexBackedDexFile readRawDexFile(byte[] buf, int offset, Opcodes opcodes) throws IOException {
        DexUtil.verifyDexHeader(buf, offset);
        return new DexBackedDexFile(opcodes, buf, offset);
    }

    public static void writeRawDexFile(File file, DexFile dexFile, int maxDexPoolSize, DexIO.Logger logger) throws IOException {
        DexIO.writeRawDexSingleThread(new FileDataStore(file), dexFile, maxDexPoolSize, logger, file);
    }

    public static void writeRawDexFile(File file, DexFile dexFile, int maxDexPoolSize) throws IOException {
        DexIO.writeRawDexSingleThread(new FileDataStore(file), dexFile, maxDexPoolSize, null, null);
    }

    public static void writeRawDexFile(DexDataStore dataStore, DexFile dexFile, int maxDexPoolSize) throws IOException {
        DexIO.writeRawDexSingleThread(dataStore, dexFile, maxDexPoolSize, null, null);
    }
}

