/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.util;

import lanchon.dexpatcher.core.util.DexUtils;

public class TypeName {
    public static String fromClassDescriptor(String descriptor) {
        if (!DexUtils.isClassDescriptor(descriptor)) {
            throw TypeName.invalidTypeDescriptor(descriptor);
        }
        int l = descriptor.length();
        StringBuilder sb = new StringBuilder(l - 2);
        for (int i = 1; i < l - 1; ++i) {
            char c = descriptor.charAt(i);
            sb.append(c == '/' ? (char)'.' : (char)c);
        }
        return sb.toString();
    }

    public static String toClassDescriptor(String name) {
        int l = name.length();
        StringBuilder sb = new StringBuilder(l + 2);
        sb.append('L');
        for (int i = 0; i < l; ++i) {
            char c = name.charAt(i);
            if (c == '.') {
                c = '/';
            }
            sb.append(c);
        }
        sb.append(';');
        return sb.toString();
    }

    public static String fromFieldDescriptor(String descriptor) {
        if (descriptor.length() == 0) {
            throw TypeName.invalidTypeDescriptor(descriptor);
        }
        switch (descriptor.charAt(0)) {
            case '[': {
                return TypeName.fromFieldDescriptor(descriptor.substring(1)) + "[]";
            }
            case 'L': {
                return TypeName.fromClassDescriptor(descriptor);
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
        }
        throw TypeName.invalidTypeDescriptor(descriptor);
    }

    public static String fromReturnDescriptor(String descriptor) {
        return "V".equals(descriptor) ? "void" : TypeName.fromFieldDescriptor(descriptor);
    }

    private static RuntimeException invalidTypeDescriptor(String descriptor) {
        return new RuntimeException("Invalid type descriptor (" + descriptor + ")");
    }

    private TypeName() {
    }
}

