/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.util;

import lanchon.dexpatcher.core.logger.Logger;
import lanchon.dexpatcher.core.patcher.AnnotatableSetPatcher;
import lanchon.dexpatcher.core.patcher.ClassSetPatcher;
import lanchon.dexpatcher.core.patcher.FieldSetPatcher;
import lanchon.dexpatcher.core.patcher.MethodSetPatcher;
import org.jf.dexlib2.AccessFlags;

public abstract class AccessFlagLogger {
    private final String item;
    private final int oldFlags;
    private final int newFlags;

    protected AccessFlagLogger(String item, int oldFlags, int newFlags) {
        this.item = item;
        this.oldFlags = oldFlags;
        this.newFlags = newFlags;
    }

    protected abstract void log(Logger.Level var1, String var2);

    private void log(Logger.Level level, AccessFlags flag, String message) {
        this.log(level, "'" + (Object)((Object)flag) + "' modifier " + message);
    }

    private void flag(AccessFlags flag, Logger.Level level) {
        this.flag(flag, level, level);
    }

    private void flag(AccessFlags flag, Logger.Level added, Logger.Level removed) {
        boolean isSet = flag.isSet(this.newFlags);
        if (isSet != flag.isSet(this.oldFlags)) {
            Logger.Level level = isSet ? added : removed;
            this.log(level, flag, (isSet ? "added to " : "removed from ") + this.item);
        }
    }

    private void scopeFlags(Logger.Level level) {
        this.scopeFlags(level, level);
    }

    private void scopeFlags(Logger.Level decreased, Logger.Level increased) {
        AccessFlags newScope = this.getScope(this.newFlags);
        AccessFlags oldScope = this.getScope(this.oldFlags);
        if (oldScope != null && newScope != null) {
            if (oldScope != newScope) {
                Logger.Level level = oldScope == AccessFlags.PRIVATE || newScope == AccessFlags.PUBLIC ? increased : decreased;
                this.log(level, oldScope, "changed to '" + (Object)((Object)newScope) + "' in " + this.item);
            }
        } else {
            this.flag(AccessFlags.PUBLIC, increased, decreased);
            this.flag(AccessFlags.PRIVATE, decreased, increased);
            this.flag(AccessFlags.PROTECTED, increased, decreased);
        }
    }

    private AccessFlags getScope(int flags) {
        boolean isProtected;
        boolean isPrivate;
        boolean isPublic = AccessFlags.PUBLIC.isSet(flags);
        int n = (isPublic ? 1 : 0) + ((isPrivate = AccessFlags.PRIVATE.isSet(flags)) ? 1 : 0) + ((isProtected = AccessFlags.PROTECTED.isSet(flags)) ? 1 : 0);
        if (n != 1) {
            return null;
        }
        if (isPublic) {
            return AccessFlags.PUBLIC;
        }
        if (isPrivate) {
            return AccessFlags.PRIVATE;
        }
        if (isProtected) {
            return AccessFlags.PROTECTED;
        }
        throw new AssertionError((Object)"Unexpected scope");
    }

    public void allFlags(AnnotatableSetPatcher<?> patcher, boolean keepInterface, boolean ensureInterface, boolean keepImplementation, Logger.Level warningLevel) {
        Logger.Level warnOnEnsureInterface;
        boolean isClass = patcher instanceof ClassSetPatcher;
        boolean isField = patcher instanceof FieldSetPatcher;
        boolean isMethod = patcher instanceof MethodSetPatcher;
        boolean checkInterface = keepInterface || ensureInterface;
        Logger.Level warn = warningLevel;
        Logger.Level warnOnKeepInterface = keepInterface ? warn : Logger.Level.INFO;
        Logger.Level level = warnOnEnsureInterface = ensureInterface ? warn : Logger.Level.INFO;
        if (checkInterface) {
            if (isMethod && !AccessFlags.STATIC.isSet(this.oldFlags | this.newFlags) && AccessFlags.PRIVATE.isSet(this.oldFlags ^ this.newFlags)) {
                this.scopeFlags(warn);
            } else {
                this.scopeFlags(warnOnKeepInterface, warnOnEnsureInterface);
            }
        } else {
            this.scopeFlags(Logger.Level.DEBUG);
        }
        if (checkInterface) {
            if (isClass) {
                this.flag(AccessFlags.FINAL, warnOnKeepInterface, warnOnEnsureInterface);
            } else if (isField) {
                if (AccessFlags.STATIC.isSet(this.oldFlags | this.newFlags)) {
                    this.flag(AccessFlags.FINAL, warn, Logger.Level.WARN);
                } else {
                    this.flag(AccessFlags.FINAL, warnOnKeepInterface, ensureInterface ? Logger.Level.WARN : Logger.Level.INFO);
                }
            } else if (isMethod) {
                this.flag(AccessFlags.FINAL, !AccessFlags.PRIVATE.isSet(this.oldFlags) ? warnOnKeepInterface : Logger.Level.INFO, !AccessFlags.PRIVATE.isSet(this.newFlags) ? warnOnEnsureInterface : Logger.Level.INFO);
            }
        } else {
            this.flag(AccessFlags.FINAL, Logger.Level.INFO);
        }
        this.flag(AccessFlags.VOLATILE, Logger.Level.INFO, checkInterface ? warn : Logger.Level.INFO);
        this.flag(AccessFlags.TRANSIENT, checkInterface ? warn : Logger.Level.INFO);
        this.flag(AccessFlags.VARARGS, Logger.Level.INFO);
        this.flag(AccessFlags.CONSTRUCTOR, checkInterface ? warn : Logger.Level.DEBUG);
        this.flag(AccessFlags.STATIC, isMethod && keepImplementation ? Logger.Level.ERROR : warn);
        this.flag(AccessFlags.INTERFACE, warn);
        this.flag(AccessFlags.ANNOTATION, warn);
        this.flag(AccessFlags.ENUM, warn);
        this.flag(AccessFlags.SYNCHRONIZED, keepImplementation ? warn : Logger.Level.DEBUG);
        this.flag(AccessFlags.NATIVE, keepImplementation ? warn : Logger.Level.DEBUG);
        if (keepImplementation) {
            this.flag(AccessFlags.ABSTRACT, isMethod ? Logger.Level.ERROR : warn);
        } else {
            this.flag(AccessFlags.ABSTRACT, warnOnKeepInterface, warnOnEnsureInterface);
        }
        this.flag(AccessFlags.STRICTFP, keepImplementation ? warn : Logger.Level.DEBUG);
        this.flag(AccessFlags.DECLARED_SYNCHRONIZED, keepImplementation ? warn : Logger.Level.DEBUG);
        this.flag(AccessFlags.BRIDGE, Logger.Level.DEBUG);
        this.flag(AccessFlags.SYNTHETIC, Logger.Level.DEBUG);
    }
}

