/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.patcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lanchon.dexpatcher.core.Action;
import lanchon.dexpatcher.core.Context;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.PatcherAnnotation;
import lanchon.dexpatcher.core.logger.Logger;
import lanchon.dexpatcher.core.model.BasicMethod;
import lanchon.dexpatcher.core.model.BasicMethodImplementation;
import lanchon.dexpatcher.core.patcher.ClassSetPatcher;
import lanchon.dexpatcher.core.patcher.MemberSetPatcher;
import lanchon.dexpatcher.core.util.DexUtils;
import lanchon.dexpatcher.core.util.Id;
import lanchon.dexpatcher.core.util.Label;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.debug.SetSourceFile;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.immutable.ImmutableMethodImplementation;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import org.jf.dexlib2.immutable.instruction.ImmutableInstructionFactory;
import org.jf.dexlib2.rewriter.DexRewriter;
import org.jf.dexlib2.rewriter.InstructionRewriter;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterModule;
import org.jf.dexlib2.rewriter.Rewriters;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.util.TypeUtils;

public class MethodSetPatcher
extends MemberSetPatcher<Method> {
    private Method sourceFileMethod;
    private int sourceFileLine;
    private boolean staticConstructorFound;

    public MethodSetPatcher(ClassSetPatcher parent, PatcherAnnotation annotation) {
        super(parent, annotation);
    }

    protected void setSourceFileMethod(Method sourceFileMethod) {
        this.sourceFileMethod = sourceFileMethod;
        this.sourceFileLine = 0;
    }

    @Override
    protected int getSourceFileLine() {
        if (this.sourceFileMethod != null) {
            MethodImplementation mi = this.sourceFileMethod.getImplementation();
            if (mi != null) {
                for (DebugItem debugItem : mi.getDebugItems()) {
                    if (debugItem instanceof LineNumber) {
                        this.sourceFileLine = ((LineNumber)debugItem).getLineNumber();
                        break;
                    }
                    if (!(debugItem instanceof SetSourceFile)) continue;
                    break;
                }
            }
            this.sourceFileMethod = null;
        }
        return this.sourceFileLine;
    }

    @Override
    protected void clearLogPrefix() {
        super.clearLogPrefix();
        this.setSourceFileMethod(null);
    }

    @Override
    protected void setupLogPrefix(String id, Method item, Method patch, Method patched) {
        this.setupLogPrefix(this.getItemLabel() + " '" + Label.ofMethod(item) + "'");
        this.setSourceFileMethod(patch);
    }

    @Override
    public Collection<Method> process(Iterable<? extends Method> sourceSet, int sourceSetSizeHint, Iterable<? extends Method> patchSet, int patchSetSizeHint) {
        this.staticConstructorFound = false;
        Collection<Method> methods = super.process(sourceSet, sourceSetSizeHint, patchSet, patchSetSizeHint);
        if (this.explicitStaticConstructorAction != null && this.explicitStaticConstructorAction != Action.NONE && !this.staticConstructorFound) {
            this.log(Logger.Level.ERROR, "static constructor not found");
        }
        return methods;
    }

    @Override
    protected final String getId(Method item) {
        return Id.ofMethod(item);
    }

    @Override
    protected String getItemLabel() {
        return "method";
    }

    @Override
    protected Action getDefaultAction(String patchId, Method patch) throws PatchException {
        if (DexUtils.isStaticConstructor(patchId, patch)) {
            this.staticConstructorFound = true;
            if (this.resolvedStaticConstructorAction == Action.NONE) {
                Action action = this.targetExists("<clinit>..V") ? Action.APPEND : Action.ADD;
                this.log(Logger.Level.INFO, "implicit " + action.getLabel() + " of static constructor");
                return action;
            }
            if (this.explicitStaticConstructorAction != null) {
                return this.explicitStaticConstructorAction;
            }
        } else if (DexUtils.isDefaultConstructor(patchId, patch) && this.resolvedDefaultAction == Action.NONE && !this.getContext().isConstructorAutoIgnoreDisabled()) {
            if (DexUtils.hasTrivialConstructorImplementation(patch)) {
                this.log(Logger.Level.INFO, "implicit ignore of trivial default constructor");
                return Action.IGNORE;
            }
            throw new PatchException("no action defined for non-trivial default constructor");
        }
        return super.getDefaultAction(patchId, patch);
    }

    @Override
    protected String getTargetId(String patchId, Method patch, PatcherAnnotation annotation) {
        String targetLabel;
        String targetId;
        String resolvedTarget;
        String target = annotation.getTarget();
        String string = resolvedTarget = target != null ? target : patch.getName();
        if (this.isTaggedByLastParameter(patch, true)) {
            ArrayList<? extends MethodParameter> parameters = new ArrayList<MethodParameter>(patch.getParameters());
            parameters.remove(parameters.size() - 1);
            targetId = Id.ofMethod(parameters, patch.getReturnType(), resolvedTarget);
            targetLabel = Label.ofMethod(parameters, patch.getReturnType(), resolvedTarget);
        } else {
            targetId = target != null ? Id.ofMethod(patch, target) : patchId;
            targetLabel = Label.ofTargetMember(resolvedTarget);
        }
        if (this.shouldLogTarget(patchId, targetId)) {
            this.extendLogPrefixWithTargetLabel(targetLabel);
        }
        return targetId;
    }

    private boolean isTaggedByLastParameter(Method patch, boolean warn) {
        List<? extends MethodParameter> parameters = patch.getParameters();
        int size = parameters.size();
        if (size == 0) {
            return false;
        }
        MethodParameter lastParameter = parameters.get(parameters.size() - 1);
        Context context = this.getContext();
        for (Annotation annotation : lastParameter.getAnnotations()) {
            if (context.getActionFromMarkerTypeDescriptor(annotation.getType()) != Action.IGNORE) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Method onSimpleAdd(Method patch, PatcherAnnotation annotation) {
        if (patch.getAnnotations() == annotation.getFilteredAnnotations()) {
            return patch;
        }
        return new BasicMethod(patch.getDefiningClass(), patch.getName(), patch.getParameters(), patch.getReturnType(), patch.getAccessFlags(), annotation.getFilteredAnnotations(), patch.getImplementation());
    }

    @Override
    protected Method onSimpleEdit(Method patch, PatcherAnnotation annotation, Method target, boolean inPlace) {
        if (!inPlace && AccessFlags.NATIVE.isSet(patch.getAccessFlags() & target.getAccessFlags())) {
            this.log(Logger.Level.ERROR, "cannot rename native method");
        }
        MethodImplementation implementation = target.getImplementation();
        if (this.isTaggedByLastParameter(patch, false)) {
            List<? extends MethodParameter> parameters = patch.getParameters();
            MethodParameter lastParameter = parameters.get(parameters.size() - 1);
            int tagRegisterCount = TypeUtils.isWideType(lastParameter) ? 2 : 1;
            implementation = new BasicMethodImplementation(implementation.getRegisterCount() + tagRegisterCount, implementation.getInstructions(), implementation.getTryBlocks(), implementation.getDebugItems());
        }
        BasicMethod patched = new BasicMethod(patch.getDefiningClass(), patch.getName(), patch.getParameters(), patch.getReturnType(), patch.getAccessFlags(), annotation.getFilteredAnnotations(), implementation);
        return super.onSimpleEdit(patched, annotation, target, inPlace);
    }

    @Override
    protected Method onSimpleReplace(Method patch, PatcherAnnotation annotation, Method target, boolean inPlace) {
        return this.onSimpleAdd(patch, annotation);
    }

    @Override
    protected void onWrap(String patchId, Method patch, PatcherAnnotation annotation) throws PatchException {
        if (DexUtils.isStaticConstructor(patchId, patch) || DexUtils.isInstanceConstructor(patchId, patch)) {
            throw Action.WRAP.invalidAction();
        }
        Method target = this.findTargetNonNative(patchId, patch, annotation);
        BasicMethod wrapSource = new BasicMethod(target.getDefiningClass(), this.createMethodName(patch, "__$wrapSource"), target.getParameters(), target.getReturnType(), MethodSetPatcher.createMethodFlags(target), target.getAnnotations(), target.getImplementation());
        this.addPatched(patch, wrapSource);
        BasicMethod wrapMain = new BasicMethod(patch.getDefiningClass(), patch.getName(), patch.getParameters(), patch.getReturnType(), patch.getAccessFlags(), annotation.getFilteredAnnotations(), this.replaceMethodInvocations(patch.getImplementation(), patch, wrapSource));
        this.addPatched(patch, wrapMain);
    }

    @Override
    protected void onSplice(String patchId, Method patch, PatcherAnnotation annotation, Action action) throws PatchException {
        if (DexUtils.isInstanceConstructor(patchId, patch)) {
            throw action.invalidAction();
        }
        if (!"V".equals(patch.getReturnType())) {
            throw new PatchException(action.getLabel() + " action can only be applied to methods that return void");
        }
        boolean prepend = action == Action.PREPEND;
        Method target = this.findTargetNonNative(patchId, patch, annotation);
        BasicMethod spliceSource = new BasicMethod(target.getDefiningClass(), this.createMethodName(patch, prepend ? "__$prependSource" : "__$appendSource"), target.getParameters(), target.getReturnType(), MethodSetPatcher.createMethodFlags(target), target.getAnnotations(), target.getImplementation());
        this.addPatched(patch, spliceSource);
        BasicMethod splicePatch = new BasicMethod(patch.getDefiningClass(), this.createMethodName(patch, prepend ? "__$prependPatch" : "__$appendPatch"), patch.getParameters(), patch.getReturnType(), MethodSetPatcher.createMethodFlags(patch), annotation.getFilteredAnnotations(), patch.getImplementation());
        this.addPatched(patch, splicePatch);
        BasicMethod spliceMain = new BasicMethod(patch.getDefiningClass(), patch.getName(), patch.getParameters(), patch.getReturnType(), patch.getAccessFlags(), annotation.getFilteredAnnotations(), MethodSetPatcher.createCallSequence(MethodUtil.getParameterRegisterCount(patch), prepend ? splicePatch : spliceSource, prepend ? spliceSource : splicePatch));
        this.addPatched(patch, spliceMain);
    }

    private Method findTargetNonNative(String patchId, Method patch, PatcherAnnotation annotation) throws PatchException {
        if (AccessFlags.NATIVE.isSet(patch.getAccessFlags())) {
            throw new PatchException("patch method is native");
        }
        String targetId = this.getTargetId(patchId, patch, annotation);
        Method target = (Method)this.findTarget(targetId, false);
        if (AccessFlags.NATIVE.isSet(target.getAccessFlags())) {
            throw new PatchException("target method is native");
        }
        return target;
    }

    private String createMethodName(Method base, String suffix) {
        String prefix = base.getName();
        int pl = prefix.length();
        if (pl >= 2 && prefix.charAt(0) == '<' && prefix.charAt(pl - 1) == '>') {
            prefix = "__$" + prefix.substring(1, pl - 1);
        }
        String baseName = prefix + suffix;
        int n = 1;
        String name = baseName;
        while (this.targetExists(Id.ofMethod(base, name))) {
            name = baseName + ++n;
        }
        return name;
    }

    private static int createMethodFlags(Method method) {
        int flags = method.getAccessFlags();
        flags &= ~(AccessFlags.PUBLIC.getValue() | AccessFlags.PROTECTED.getValue() | AccessFlags.CONSTRUCTOR.getValue());
        return flags |= AccessFlags.PRIVATE.getValue();
    }

    private MethodImplementation replaceMethodInvocations(MethodImplementation implementation, final Method from, final Method to) throws PatchException {
        final boolean fromIsDirect = MethodUtil.isDirect(from);
        final Opcode toInvoke = MethodSetPatcher.getInvokeOpcode(to.getAccessFlags(), false);
        final Opcode toInvokeRange = MethodSetPatcher.getInvokeOpcode(to.getAccessFlags(), true);
        DexRewriter rewriter = new DexRewriter(new RewriterModule(){

            @Override
            public Rewriter<Instruction> getInstructionRewriter(Rewriters rewriters) {
                return new InstructionRewriter(rewriters){

                    @Override
                    public Instruction rewrite(Instruction instruction) {
                        boolean invokeIsDirect;
                        if (!(instruction instanceof ReferenceInstruction)) {
                            return instruction;
                        }
                        Reference reference = ((ReferenceInstruction)instruction).getReference();
                        if (!from.equals(reference)) {
                            return instruction;
                        }
                        switch (instruction.getOpcode()) {
                            case INVOKE_DIRECT: 
                            case INVOKE_DIRECT_RANGE: 
                            case INVOKE_STATIC: 
                            case INVOKE_STATIC_RANGE: {
                                invokeIsDirect = true;
                                break;
                            }
                            case INVOKE_VIRTUAL: 
                            case INVOKE_VIRTUAL_RANGE: {
                                invokeIsDirect = false;
                                break;
                            }
                            case INVOKE_SUPER: 
                            case INVOKE_SUPER_RANGE: 
                            case INVOKE_INTERFACE: 
                            case INVOKE_INTERFACE_RANGE: {
                                invokeIsDirect = false;
                                if (fromIsDirect != invokeIsDirect) break;
                                MethodSetPatcher.this.log(Logger.Level.ERROR, "unsupported invocation type (" + (Object)((Object)instruction.getOpcode()) + ")");
                                return instruction;
                            }
                            default: {
                                return instruction;
                            }
                        }
                        if (fromIsDirect != invokeIsDirect) {
                            MethodSetPatcher.this.log(Logger.Level.ERROR, "unexpected invocation type (" + (Object)((Object)instruction.getOpcode()) + ")");
                            return instruction;
                        }
                        if (instruction instanceof Instruction35c) {
                            return new InstructionRewriter.RewrittenInstruction35c((Instruction35c)instruction){

                                @Override
                                public Opcode getOpcode() {
                                    return toInvoke;
                                }

                                @Override
                                public Reference getReference() {
                                    return to;
                                }
                            };
                        }
                        if (instruction instanceof Instruction3rc) {
                            return new InstructionRewriter.RewrittenInstruction3rc((Instruction3rc)instruction){

                                @Override
                                public Opcode getOpcode() {
                                    return toInvokeRange;
                                }

                                @Override
                                public Reference getReference() {
                                    return to;
                                }
                            };
                        }
                        MethodSetPatcher.this.log(Logger.Level.ERROR, "unexpected invocation instruction type (" + instruction.getClass().getSimpleName() + ": " + (Object)((Object)instruction.getOpcode()) + ")");
                        return instruction;
                    }
                };
            }
        });
        return rewriter.getMethodImplementationRewriter().rewrite(implementation);
    }

    private static MethodImplementation createCallSequence(int parameterCount, Method ... methods) throws PatchException {
        ImmutableInstructionFactory factory = ImmutableInstructionFactory.INSTANCE;
        ArrayList<ImmutableInstruction> instructions = new ArrayList<ImmutableInstruction>(methods.length + 1);
        for (Method method : methods) {
            Opcode opcode = MethodSetPatcher.getInvokeOpcode(method.getAccessFlags(), true);
            instructions.add(factory.makeInstruction3rc(opcode, 0, parameterCount, method));
        }
        instructions.add(factory.makeInstruction10x(Opcode.RETURN_VOID));
        return new ImmutableMethodImplementation(parameterCount, instructions, null, null);
    }

    private static Opcode getInvokeOpcode(int methodFlags, boolean range) throws PatchException {
        if (AccessFlags.CONSTRUCTOR.isSet(methodFlags)) {
            throw new PatchException("unsupported constructor invocation");
        }
        if (AccessFlags.STATIC.isSet(methodFlags)) {
            return range ? Opcode.INVOKE_STATIC_RANGE : Opcode.INVOKE_STATIC;
        }
        if (AccessFlags.PRIVATE.isSet(methodFlags)) {
            return range ? Opcode.INVOKE_DIRECT_RANGE : Opcode.INVOKE_DIRECT;
        }
        return range ? Opcode.INVOKE_VIRTUAL_RANGE : Opcode.INVOKE_VIRTUAL;
    }
}

