/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.patcher;

import java.util.Collections;
import java.util.Set;
import lanchon.dexpatcher.core.Action;
import lanchon.dexpatcher.core.Context;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.PatcherAnnotation;
import lanchon.dexpatcher.core.model.BasicClassDef;
import lanchon.dexpatcher.core.patcher.AnnotatableSetPatcher;
import lanchon.dexpatcher.core.patcher.FieldSetPatcher;
import lanchon.dexpatcher.core.patcher.MethodSetPatcher;
import lanchon.dexpatcher.core.util.DexUtils;
import lanchon.dexpatcher.core.util.Id;
import lanchon.dexpatcher.core.util.Label;
import lanchon.dexpatcher.core.util.TypeName;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.rewriter.DexRewriter;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterModule;
import org.jf.dexlib2.rewriter.Rewriters;

public class ClassSetPatcher
extends AnnotatableSetPatcher<ClassDef> {
    public ClassSetPatcher(Context context) {
        super(context);
    }

    @Override
    protected void clearLogPrefix() {
        super.clearLogPrefix();
        this.setSourceFileClass(null);
    }

    @Override
    protected void setupLogPrefix(String id, ClassDef item, ClassDef patch, ClassDef patched) {
        this.setupLogPrefix(this.getItemLabel() + " '" + Label.ofClass(item) + "'");
        this.setSourceFileClass(patch);
    }

    @Override
    protected final String getId(ClassDef item) {
        return Id.ofClass(item);
    }

    @Override
    protected String getItemLabel() {
        return "type";
    }

    @Override
    protected int getAccessFlags(ClassDef item) {
        return DexUtils.getClassAccessFlags(item);
    }

    @Override
    protected Action getDefaultAction(String patchId, ClassDef patch) {
        return Action.ADD;
    }

    @Override
    protected void onPrepare(String patchId, ClassDef patch, PatcherAnnotation annotation) throws PatchException {
        if (annotation.getRecursive()) {
            throw PatcherAnnotation.invalidElement("recursive");
        }
        if (annotation.getStaticConstructorAction() == Action.WRAP) {
            throw new PatchException("invalid static constructor action (wrap)");
        }
    }

    @Override
    protected String getTargetId(String patchId, ClassDef patch, PatcherAnnotation annotation) {
        String targetId = patchId;
        String target = annotation.getTarget();
        String targetClass = annotation.getTargetClass();
        if (target != null || targetClass != null) {
            String targetDescriptor;
            if (target != null) {
                if (DexUtils.isClassDescriptor(target)) {
                    targetDescriptor = target;
                } else {
                    String base = TypeName.fromClassDescriptor(patch.getType());
                    targetDescriptor = TypeName.toClassDescriptor(ClassSetPatcher.resolveTarget(target, base));
                }
            } else {
                targetDescriptor = targetClass;
            }
            targetId = Id.fromClassDescriptor(targetDescriptor);
        }
        if (this.shouldLogTarget(patchId, targetId)) {
            this.extendLogPrefixWithTargetLabel(Label.fromClassId(targetId));
        }
        return targetId;
    }

    @Override
    protected ClassDef onSimpleAdd(ClassDef patch, PatcherAnnotation annotation) {
        if (patch.getAnnotations() == annotation.getFilteredAnnotations()) {
            return patch;
        }
        return new BasicClassDef(patch.getType(), patch.getAccessFlags(), patch.getSuperclass(), patch.getInterfaces(), patch.getSourceFile(), annotation.getFilteredAnnotations(), patch.getStaticFields(), patch.getInstanceFields(), patch.getDirectMethods(), patch.getVirtualMethods());
    }

    @Override
    protected ClassDef onSimpleEdit(ClassDef patch, PatcherAnnotation annotation, ClassDef target, boolean inPlace) {
        Set<? extends Annotation> annotations;
        ClassDef source;
        if (annotation.getContentOnly()) {
            source = target;
            annotations = target.getAnnotations();
            if (!inPlace) {
                patch = ClassSetPatcher.renameClass(patch, target.getType());
            }
        } else {
            super.onSimpleEdit(patch, annotation, target, inPlace);
            source = patch;
            annotations = annotation.getFilteredAnnotations();
            if (!inPlace) {
                target = ClassSetPatcher.renameClass(target, patch.getType());
            }
        }
        return new BasicClassDef(source.getType(), source.getAccessFlags(), source.getSuperclass(), source.getInterfaces(), source.getSourceFile(), annotations, Collections.unmodifiableCollection(new FieldSetPatcher(this, annotation).process(target.getFields(), patch.getFields())), Collections.unmodifiableCollection(new MethodSetPatcher(this, annotation).process(target.getMethods(), patch.getMethods())));
    }

    @Override
    protected ClassDef onSimpleReplace(ClassDef patch, PatcherAnnotation annotation, ClassDef target, boolean inPlace) {
        Set<? extends Annotation> annotations;
        ClassDef source;
        if (annotation.getContentOnly()) {
            source = target;
            annotations = target.getAnnotations();
            if (!inPlace) {
                patch = ClassSetPatcher.renameClass(patch, target.getType());
            }
        } else {
            source = patch;
            annotations = annotation.getFilteredAnnotations();
        }
        return new BasicClassDef(source.getType(), source.getAccessFlags(), source.getSuperclass(), source.getInterfaces(), source.getSourceFile(), annotations, patch.getStaticFields(), patch.getInstanceFields(), patch.getDirectMethods(), patch.getVirtualMethods());
    }

    private static String resolveTarget(String name, String base) {
        int nameDot = name.indexOf(46);
        if (nameDot < 0) {
            int baseEnd = base.lastIndexOf(46);
            if (name.indexOf(36) < 0) {
                baseEnd = Math.max(baseEnd, base.lastIndexOf(36));
            }
            if (baseEnd >= 0) {
                name = base.substring(0, baseEnd + 1) + name;
            }
        } else if (nameDot == 0) {
            name = name.substring(1);
        }
        return name;
    }

    private static ClassDef renameClass(ClassDef classDef, final String to) {
        final String from = classDef.getType();
        DexRewriter rewriter = new DexRewriter(new RewriterModule(){

            @Override
            public Rewriter<String> getTypeRewriter(Rewriters rewriters) {
                return new Rewriter<String>(){

                    @Override
                    public String rewrite(String value) {
                        return from.equals(value) ? to : value;
                    }
                };
            }
        });
        return rewriter.getClassDefRewriter().rewrite(classDef);
    }
}

