/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.patcher;

import lanchon.dexpatcher.core.Action;
import lanchon.dexpatcher.core.Context;
import lanchon.dexpatcher.core.PatchException;
import lanchon.dexpatcher.core.logger.Logger;
import lanchon.dexpatcher.core.patcher.AbstractPatcher;

public abstract class ActionBasedPatcher<T, C extends ActionContext>
extends AbstractPatcher<T> {
    protected ActionBasedPatcher(Context context) {
        super(context);
    }

    protected ActionBasedPatcher(AbstractPatcher<?> parent) {
        super(parent);
    }

    @Override
    protected void onPatch(String patchId, T patch) throws PatchException {
        C actionContext = this.getActionContext(patchId, patch);
        this.onPrepare(patchId, patch, actionContext);
        Action action = actionContext.getAction();
        if (this.isLogging(Logger.Level.DEBUG)) {
            this.log(Logger.Level.DEBUG, action.getLabel());
        }
        switch (action) {
            case ADD: {
                this.onAdd(patchId, patch, actionContext);
                break;
            }
            case EDIT: {
                this.onEdit(patchId, patch, actionContext);
                break;
            }
            case REPLACE: {
                this.onReplace(patchId, patch, actionContext);
                break;
            }
            case REMOVE: {
                this.onRemove(patchId, patch, actionContext);
                break;
            }
            case IGNORE: {
                this.onIgnore(patchId, patch, actionContext);
                break;
            }
            case WRAP: {
                this.onWrap(patchId, patch, actionContext);
                break;
            }
            case PREPEND: {
                this.onSplice(patchId, patch, actionContext, Action.PREPEND);
                break;
            }
            case APPEND: {
                this.onSplice(patchId, patch, actionContext, Action.APPEND);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected action");
            }
        }
    }

    protected void onAdd(String patchId, T patch, C actionContext) throws PatchException {
        T patched = this.onSimpleAdd(patch, actionContext);
        this.addPatched(patch, patched);
    }

    protected void onEdit(String patchId, T patch, C actionContext) throws PatchException {
        String targetId = this.getTargetId(patchId, patch, actionContext);
        boolean inPlace = patchId.equals(targetId);
        Object target = this.findTarget(targetId, inPlace);
        T patched = this.onSimpleEdit(patch, actionContext, target, inPlace);
        this.addPatched(patch, patched);
    }

    protected void onReplace(String patchId, T patch, C actionContext) throws PatchException {
        String targetId = this.getTargetId(patchId, patch, actionContext);
        boolean inPlace = patchId.equals(targetId);
        Object target = this.findTarget(targetId, false);
        T patched = this.onSimpleReplace(patch, actionContext, target, inPlace);
        this.addPatched(patch, patched);
    }

    protected void onRemove(String patchId, T patch, C actionContext) throws PatchException {
        String targetId = this.getTargetId(patchId, patch, actionContext);
        Object target = this.findTarget(targetId, false);
        this.onSimpleRemove(patch, actionContext, target);
    }

    protected void onIgnore(String patchId, T patch, C actionContext) throws PatchException {
    }

    protected void onWrap(String patchId, T patch, C actionContext) throws PatchException {
        throw Action.WRAP.invalidAction();
    }

    protected void onSplice(String patchId, T patch, C actionContext, Action action) throws PatchException {
        throw action.invalidAction();
    }

    protected abstract C getActionContext(String var1, T var2) throws PatchException;

    protected void onPrepare(String patchId, T patch, C actionContext) throws PatchException {
    }

    protected abstract String getTargetId(String var1, T var2, C var3) throws PatchException;

    protected abstract T onSimpleAdd(T var1, C var2);

    protected abstract T onSimpleEdit(T var1, C var2, T var3, boolean var4);

    protected abstract T onSimpleReplace(T var1, C var2, T var3, boolean var4);

    protected void onSimpleRemove(T patch, C actionContext, T target) {
    }

    public static interface ActionContext {
        public Action getAction();
    }
}

