/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core.logger;

import java.io.PrintStream;
import java.io.PrintWriter;
import lanchon.dexpatcher.core.logger.Logger;

public class BasicLogger
extends Logger {
    private final PrintWriter out;
    private final PrintWriter err;

    public BasicLogger() {
        this(System.out, System.err);
    }

    public BasicLogger(PrintStream out) {
        this(out, null);
    }

    public BasicLogger(PrintWriter out) {
        this(out, null);
    }

    public BasicLogger(PrintStream out, PrintStream err) {
        this(new PrintWriter(out, true), err != null ? new PrintWriter(err, true) : null);
    }

    public BasicLogger(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
        this.flush();
    }

    @Override
    protected void doLog(Logger.Level level, String message, Throwable throwable) {
        boolean isError = false;
        switch (level) {
            case ERROR: 
            case FATAL: {
                isError = true;
            }
            case DEBUG: 
            case INFO: 
            case WARN: {
                message = level.getLabel() + ": " + message;
            }
            case NONE: {
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected log level");
            }
        }
        if (isError && this.err != null) {
            this.out.flush();
            this.err.println(message);
            if (throwable != null) {
                throwable.printStackTrace(this.err);
            }
            this.err.flush();
        } else {
            this.out.println(message);
            if (throwable != null) {
                throwable.printStackTrace(this.out);
                this.out.flush();
            }
        }
    }

    @Override
    public void flush() {
        this.out.flush();
        if (this.err != null) {
            this.err.flush();
        }
    }

    @Override
    public void close() {
        this.out.close();
        if (this.err != null) {
            this.err.close();
        }
    }
}

