/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher.core;

import java.util.HashMap;
import java.util.Map;
import lanchon.dexpatcher.core.Action;
import lanchon.dexpatcher.core.Marker;
import lanchon.dexpatcher.core.logger.BasicLogger;
import lanchon.dexpatcher.core.logger.Logger;
import lanchon.dexpatcher.core.util.TypeName;

public class Context {
    public static final Logger.Level DEFAULT_LOG_LEVEL = Logger.Level.WARN;
    public static final String DEFAULT_ANNOTATION_PACKAGE = "lanchon.dexpatcher.annotation";
    private Logger logger;
    private String annotationPackage;
    private boolean constructorAutoIgnoreDisabled;
    private String sourceCodeRoot;
    private Map<String, Action> actionMap;

    public Context() {
        this(DEFAULT_LOG_LEVEL);
    }

    public Context(Logger.Level logLevel) {
        BasicLogger logger = new BasicLogger();
        logger.setLogLevel(logLevel);
        this.logger = logger;
        this.setAnnotationPackage(DEFAULT_ANNOTATION_PACKAGE);
    }

    public Context(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getAnnotationPackage() {
        return this.annotationPackage;
    }

    public void setAnnotationPackage(String value) {
        if (value.equals(this.annotationPackage)) {
            return;
        }
        this.annotationPackage = value;
        Action[] actions = Action.values();
        this.actionMap = new HashMap<String, Action>(actions.length);
        for (Action action : actions) {
            Marker marker = action.getMarker();
            if (marker == null) continue;
            this.actionMap.put(this.getMarkerTypeDescriptor(marker), action);
        }
    }

    public boolean isConstructorAutoIgnoreDisabled() {
        return this.constructorAutoIgnoreDisabled;
    }

    public void setConstructorAutoIgnoreDisabled(boolean constructorAutoIgnoreDisabled) {
        this.constructorAutoIgnoreDisabled = constructorAutoIgnoreDisabled;
    }

    public String getSourceCodeRoot() {
        return this.sourceCodeRoot;
    }

    public void setSourceCodeRoot(String sourceCodeRoot) {
        this.sourceCodeRoot = sourceCodeRoot;
    }

    private String getMarkerTypeDescriptor(Marker marker) {
        return TypeName.toClassDescriptor(this.annotationPackage + "." + marker.getClassName());
    }

    public Action getActionFromMarkerTypeDescriptor(String descriptor) {
        return this.actionMap.get(descriptor);
    }
}

