/*
 * Decompiled with CFR 0.152.
 */
package lanchon.dexpatcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import lanchon.dexpatcher.Configuration;
import lanchon.dexpatcher.Parser;
import lanchon.dexpatcher.Processor;
import lanchon.dexpatcher.core.logger.BasicLogger;
import lanchon.dexpatcher.core.logger.Logger;
import org.apache.commons.cli.ParseException;

public class Main {
    public static void main(String[] args) {
        Locale.setDefault(Locale.ROOT);
        int value = Main.run(args);
        System.exit(value);
    }

    public static int run(String[] args) {
        return Main.run(args, new BasicLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(String[] args, Logger logger) {
        try {
            boolean success = Main.runWithExceptions(args, logger);
            int n = success ? 0 : 1;
            return n;
        }
        catch (ParseException e) {
            logger.log(Logger.Level.FATAL, e.getMessage());
            Parser.printUsage();
            int n = 2;
            return n;
        }
        catch (Exception e) {
            if (logger.isLogging(Logger.Level.DEBUG)) {
                logger.log(Logger.Level.FATAL, "exception:", e);
            } else {
                logger.log(Logger.Level.FATAL, "exception: " + e);
            }
            int n = 3;
            return n;
        }
        finally {
            logger.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runWithExceptions(String[] args, Logger logger) throws ParseException, IOException {
        try {
            Configuration config = Parser.parseCommandLine(args);
            if (config == null) {
                boolean bl = true;
                return bl;
            }
            logger.log(Logger.Level.NONE, Main.getHeader());
            boolean bl = Processor.processFiles(logger, config);
            return bl;
        }
        finally {
            logger.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        String FILE = "version";
        try (InputStream is = Main.class.getResourceAsStream("version");){
            String string = new BufferedReader(new InputStreamReader(is)).readLine().trim();
            return string;
        }
        catch (IOException e) {
            return "<undefined>";
        }
    }

    public static String getHeader() {
        return "DexPatcher version " + Main.getVersion() + " by Lanchon (https://dexpatcher.github.io/)";
    }

    private Main() {
    }
}

