/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.proxy.ManualEditUI;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;

public class ManualEdit
extends ProxyPlugin {
    private static String INCLUDE = ".*";
    private static String EXCLUDE = ".*\\.(gif|jpg|png|css|js|ico|swf|axd.*)$";
    private static String CONTENT = "text/.*";
    private String _includeRegex = "";
    private String _excludeRegex = "";
    private String[] _interceptMethods = null;
    private boolean _interceptRequest = false;
    private boolean _interceptResponse = false;
    private String _interceptResponseRegex = "";
    private boolean _caseSensitive = false;
    private ManualEditUI _ui = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public ManualEdit() {
        this.parseProperties();
    }

    public void parseProperties() {
        String value;
        String prop = "ManualEdit.includeRegex";
        this._includeRegex = value = Preferences.getPreference(prop, INCLUDE);
        prop = "ManualEdit.excludeRegex";
        this._excludeRegex = value = Preferences.getPreference(prop, EXCLUDE);
        prop = "ManualEdit.interceptMethods";
        value = Preferences.getPreference(prop, "GET, POST");
        this._interceptMethods = value.split(" *, *");
        prop = "ManualEdit.interceptRequest";
        value = Preferences.getPreference(prop, "false");
        this._interceptRequest = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        prop = "ManualEdit.interceptResponse";
        value = Preferences.getPreference(prop, "false");
        this._interceptResponse = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        prop = "ManualEdit.interceptResponseRegex";
        this._interceptResponseRegex = value = Preferences.getPreference(prop, CONTENT);
        prop = "ManualEdit.caseSensitive";
        value = Preferences.getPreference(prop, "false");
        this._caseSensitive = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    @Override
    public String getPluginName() {
        return new String("Manual Edit");
    }

    public void setUI(ManualEditUI ui) {
        this._ui = ui;
    }

    public void setIncludeRegex(String regex) {
        this._includeRegex = regex;
        String prop = "ManualEdit.includeRegex";
        Preferences.setPreference(prop, regex);
    }

    public String getIncludeRegex() {
        return this._includeRegex;
    }

    public void setExcludeRegex(String regex) {
        this._excludeRegex = regex;
        String prop = "ManualEdit.excludeRegex";
        Preferences.setPreference(prop, regex);
    }

    public String getExcludeRegex() {
        return this._excludeRegex;
    }

    public void setInterceptMethods(String[] methods) {
        this._interceptMethods = methods;
        String value = "";
        if (methods.length > 0) {
            value = methods[0];
            int i = 1;
            while (i < methods.length) {
                value = String.valueOf(value) + ", " + methods[i];
                ++i;
            }
        }
        String prop = "ManualEdit.interceptMethods";
        Preferences.setPreference(prop, value);
    }

    public String[] getInterceptMethods() {
        return this._interceptMethods;
    }

    public void setInterceptRequest(boolean bool) {
        this._interceptRequest = bool;
        String prop = "ManualEdit.interceptRequest";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean getInterceptRequest() {
        return this._interceptRequest;
    }

    public void setInterceptResponse(boolean bool) {
        this._interceptResponse = bool;
        String prop = "ManualEdit.interceptResponse";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean getInterceptResponse() {
        return this._interceptResponse;
    }

    public void setInterceptResponseRegex(String regex) {
        this._interceptResponseRegex = regex;
        Preferences.setPreference("ManualEdit.interceptResponseRegex", regex);
    }

    public String getInterceptResponseRegex() {
        return this._interceptResponseRegex;
    }

    public void setCaseSensitive(boolean bool) {
        this._caseSensitive = bool;
        String prop = "ManualEdit.caseSensitive";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    @Override
    public HTTPClient getProxyPlugin(HTTPClient in) {
        return new Plugin(in);
    }

    private class Plugin
    implements HTTPClient {
        private HTTPClient _in;
        private Pattern _exclude;
        private Pattern _include;
        private Pattern _content;

        public Plugin(HTTPClient in) {
            this._in = in;
            int flags = ManualEdit.this._caseSensitive ? 0 : 2;
            try {
                this._include = Pattern.compile(ManualEdit.this._includeRegex, flags);
                this._exclude = Pattern.compile(ManualEdit.this._excludeRegex, flags);
                this._content = Pattern.compile(ManualEdit.this._interceptResponseRegex, flags);
            }
            catch (PatternSyntaxException pse) {
                ManualEdit.this._logger.warning("Regex pattern is invalid, using ALL default patterns! " + pse.getMessage());
                try {
                    this._include = Pattern.compile(INCLUDE);
                    this._exclude = Pattern.compile(EXCLUDE);
                    this._content = Pattern.compile(CONTENT);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }

        @Override
        public Response fetchResponse(Request request) throws IOException {
            if (ManualEdit.this._interceptRequest) {
                String url = request.getURL().toString();
                Matcher include = this._include.matcher(url);
                Matcher exclude = this._exclude.matcher(url);
                if (!exclude.matches() && include.matches()) {
                    String method = request.getMethod();
                    int i = 0;
                    while (i < ManualEdit.this._interceptMethods.length) {
                        if (method.equals(ManualEdit.this._interceptMethods[i]) && ManualEdit.this._ui != null && (request = ManualEdit.this._ui.editRequest(request)) == null) {
                            throw new IOException("Request aborted in Manual Edit");
                        }
                        ++i;
                    }
                }
            }
            Response response = this._in.fetchResponse(request);
            if (ManualEdit.this._interceptResponse) {
                String contentType = response.getHeader("Content-Type");
                if (contentType == null || !this._content.matcher(contentType).matches()) {
                    return response;
                }
                if (ManualEdit.this._ui != null) {
                    request = response.getRequest();
                    response = ManualEdit.this._ui.editResponse(request, response);
                    if (response == null) {
                        throw new IOException("Response aborted in Manual Edit");
                    }
                    if (response.getRequest() == null) {
                        response.setRequest(request);
                    }
                    response.addHeader("X-ManualEdit", "possibly modified");
                }
            }
            return response;
        }
    }
}

