/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.AbstractConversationModel;
import org.owasp.webscarab.model.AbstractUrlModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.FileSystemStore;
import org.owasp.webscarab.model.FrameworkEvent;
import org.owasp.webscarab.model.FrameworkListener;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.SiteModelStore;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.util.MRUCache;
import org.owasp.webscarab.util.ReentrantReaderPreferenceReadWriteLock;

public class FrameworkModel {
    private ReentrantReaderPreferenceReadWriteLock _rwl = new ReentrantReaderPreferenceReadWriteLock();
    private static final Cookie[] NO_COOKIES = new Cookie[0];
    private EventListenerList _listenerList = new EventListenerList();
    private Map _urlCache = new MRUCache(200);
    private SiteModelStore _store = null;
    private FrameworkUrlModel _urlModel;
    private FrameworkConversationModel _conversationModel;
    private boolean _modified = false;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public FrameworkModel() {
        this._logger.setLevel(Level.INFO);
        this._conversationModel = new FrameworkConversationModel(this);
        this._urlModel = new FrameworkUrlModel();
    }

    public void setSession(String type, Object store, String session) throws StoreException {
        try {
            this._rwl.writeLock().acquire();
            if (type.equals("FileSystem") && store instanceof File) {
                try {
                    this._store = new FileSystemStore((File)store);
                }
                catch (Exception e) {
                    throw new StoreException("Error initialising session : " + e.getMessage());
                }
            } else {
                this._rwl.writeLock().release();
                throw new StoreException("Unknown store type " + type + " and store " + store);
            }
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._urlModel.fireUrlsChanged();
            this._conversationModel.fireConversationsChanged();
            this.fireCookiesChanged();
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
    }

    public Sync readLock() {
        return this._rwl.readLock();
    }

    public UrlModel getUrlModel() {
        return this._urlModel;
    }

    public ConversationModel getConversationModel() {
        return this._conversationModel;
    }

    public void flush() throws StoreException {
        if (this._modified) {
            try {
                this._rwl.readLock().acquire();
                try {
                    this._store.flush();
                    this._modified = false;
                }
                finally {
                    this._rwl.readLock().release();
                }
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
            }
        }
    }

    public boolean isModified() {
        return this._modified;
    }

    public ConversationID reserveConversationID() {
        return new ConversationID();
    }

    public void addConversation(ConversationID id, Date when, Request request, Response response, String origin) {
    }

    public String getConversationOrigin(ConversationID id) {
        return this.getConversationProperty(id, "ORIGIN");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getConversationDate(ConversationID id) {
        try {
            this._rwl.readLock().acquire();
            try {
                String when = this.getConversationProperty(id, "WHEN");
                if (when == null) {
                    return null;
                }
                long time = Long.parseLong(when);
                Date date = new Date(time);
                return date;
            }
            finally {
                this._rwl.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public HttpUrl getRequestUrl(ConversationID conversation) {
        try {
            this._rwl.readLock().acquire();
            try {
                if (this._urlCache.containsKey(conversation)) {
                    HttpUrl httpUrl = (HttpUrl)this._urlCache.get(conversation);
                    return httpUrl;
                }
                String url = this.getConversationProperty(conversation, "URL");
                try {
                    HttpUrl httpUrl = new HttpUrl(url);
                    this._urlCache.put(conversation, httpUrl);
                    HttpUrl httpUrl2 = httpUrl;
                    return httpUrl2;
                }
                catch (MalformedURLException mue) {
                    System.err.println("Malformed URL for Conversation " + conversation + ": " + mue);
                    this._rwl.readLock().release();
                    return null;
                }
            }
            finally {
                this._rwl.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
            return null;
        }
    }

    public void setConversationProperty(ConversationID conversation, String property, String value) {
        try {
            this._rwl.writeLock().acquire();
            this._store.setConversationProperty(conversation, property, value);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._conversationModel.fireConversationChanged(conversation, 0);
            this.fireConversationPropertyChanged(conversation, property);
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = true;
    }

    public boolean addConversationProperty(ConversationID conversation, String property, String value) {
        boolean change = false;
        try {
            this._rwl.writeLock().acquire();
            change = this._store.addConversationProperty(conversation, property, value);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            if (change) {
                this._conversationModel.fireConversationChanged(conversation, 0);
                this.fireConversationPropertyChanged(conversation, property);
            }
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = this._modified || change;
        return change;
    }

    public String getConversationProperty(ConversationID conversation, String property) {
        String[] values = this.getConversationProperties(conversation, property);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        StringBuffer value = new StringBuffer(values[0]);
        int i = 1;
        while (i < values.length) {
            value.append(", ").append(values[i]);
            ++i;
        }
        return value.toString();
    }

    public String getRequestMethod(ConversationID id) {
        return this.getConversationProperty(id, "METHOD");
    }

    public String getResponseStatus(ConversationID id) {
        return this.getConversationProperty(id, "STATUS");
    }

    public String[] getConversationProperties(ConversationID conversation, String property) {
        String[] stringArray;
        this._rwl.readLock().acquire();
        try {
            stringArray = this._store.getConversationProperties(conversation, property);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
        this._rwl.readLock().release();
        return stringArray;
    }

    private void addUrl(HttpUrl url) {
        try {
            this._rwl.readLock().acquire();
            try {
                if (!this._store.isKnownUrl(url)) {
                    HttpUrl[] path = url.getUrlHierarchy();
                    int i = 0;
                    while (i < path.length) {
                        if (!this._store.isKnownUrl(path[i])) {
                            this._rwl.readLock().release();
                            while (!this._rwl.writeLock().attempt(5000L)) {
                                this._logger.severe("Timed out waiting for write lock, trying again");
                                this._rwl.debug();
                            }
                            if (!this._store.isKnownUrl(path[i])) {
                                this._store.addUrl(path[i]);
                                this._rwl.readLock().acquire();
                                this._rwl.writeLock().release();
                                this._urlModel.fireUrlAdded(path[i], 0);
                                this._modified = true;
                            } else {
                                this._rwl.readLock().acquire();
                                this._rwl.writeLock().release();
                            }
                        }
                        ++i;
                    }
                }
            }
            finally {
                this._rwl.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
    }

    public void setUrlProperty(HttpUrl url, String property, String value) {
        this.addUrl(url);
        try {
            this._rwl.writeLock().acquire();
            this._store.setUrlProperty(url, property, value);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._urlModel.fireUrlChanged(url, 0);
            this.fireUrlPropertyChanged(url, property);
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = true;
    }

    public boolean addUrlProperty(HttpUrl url, String property, String value) {
        boolean change = false;
        this.addUrl(url);
        try {
            this._rwl.writeLock().acquire();
            change = this._store.addUrlProperty(url, property, value);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            if (change) {
                this._urlModel.fireUrlChanged(url, 0);
                this.fireUrlPropertyChanged(url, property);
            }
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = this._modified || change;
        return change;
    }

    public String[] getUrlProperties(HttpUrl url, String property) {
        String[] stringArray;
        this._rwl.readLock().acquire();
        try {
            stringArray = this._store.getUrlProperties(url, property);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
        this._rwl.readLock().release();
        return stringArray;
    }

    public String getUrlProperty(HttpUrl url, String property) {
        String[] values = this.getUrlProperties(url, property);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        StringBuffer value = new StringBuffer(30);
        value.append(values[0]);
        int i = 1;
        while (i < values.length) {
            value.append(", ").append(values[i]);
            ++i;
        }
        return value.toString();
    }

    public Request getRequest(ConversationID conversation) {
        Request request;
        this._rwl.readLock().acquire();
        try {
            request = this._store.getRequest(conversation);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
        this._rwl.readLock().release();
        return request;
    }

    public Response getResponse(ConversationID conversation) {
        Response response;
        this._rwl.readLock().acquire();
        try {
            response = this._store.getResponse(conversation);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
        this._rwl.readLock().release();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(FrameworkListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.add(FrameworkListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(FrameworkListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.remove(FrameworkListener.class, listener);
        }
    }

    public int getCookieCount() {
        int n;
        if (this._store == null) {
            return 0;
        }
        this._rwl.readLock().acquire();
        try {
            n = this._store.getCookieCount();
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return 0;
            }
        }
        this._rwl.readLock().release();
        return n;
    }

    public int getCookieCount(String key) {
        int n;
        this._rwl.readLock().acquire();
        try {
            n = this._store.getCookieCount(key);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return 0;
            }
        }
        this._rwl.readLock().release();
        return n;
    }

    public String getCookieAt(int index) {
        String string;
        this._rwl.readLock().acquire();
        try {
            string = this._store.getCookieAt(index);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
        this._rwl.readLock().release();
        return string;
    }

    public Cookie getCookieAt(String key, int index) {
        Cookie cookie;
        this._rwl.readLock().acquire();
        try {
            cookie = this._store.getCookieAt(key, index);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
        this._rwl.readLock().release();
        return cookie;
    }

    public int getIndexOfCookie(Cookie cookie) {
        int n;
        this._rwl.readLock().acquire();
        try {
            n = this._store.getIndexOfCookie(cookie);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return 0;
            }
        }
        this._rwl.readLock().release();
        return n;
    }

    public int getIndexOfCookie(String key, Cookie cookie) {
        int n;
        this._rwl.readLock().acquire();
        try {
            n = this._store.getIndexOfCookie(key, cookie);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return 0;
            }
        }
        this._rwl.readLock().release();
        return n;
    }

    public Cookie getCurrentCookie(String key) {
        Cookie cookie;
        this._rwl.readLock().acquire();
        try {
            int count = this._store.getCookieCount(key);
            cookie = this._store.getCookieAt(key, count - 1);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
        this._rwl.readLock().release();
        return cookie;
    }

    public void addCookie(Cookie cookie) {
        try {
            this._rwl.writeLock().acquire();
            boolean added = this._store.addCookie(cookie);
            if (!added) {
                this._rwl.writeLock().release();
            } else {
                this._modified = true;
                this._rwl.readLock().acquire();
                this._rwl.writeLock().release();
                this.fireCookieAdded(cookie);
                this._rwl.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
    }

    public void removeCookie(Cookie cookie) {
        try {
            this._rwl.writeLock().acquire();
            boolean deleted = this._store.removeCookie(cookie);
            if (deleted) {
                this._modified = true;
                this._rwl.readLock().acquire();
                this._rwl.writeLock().release();
                this.fireCookieRemoved(cookie);
                this._rwl.readLock().release();
            } else {
                this._rwl.writeLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
    }

    public Cookie[] getCookiesForUrl(HttpUrl url) {
        Cookie[] cookieArray;
        this._rwl.readLock().acquire();
        try {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            String host = url.getHost();
            String path = url.getPath();
            int size = this.getCookieCount();
            int i = 0;
            while (i < size) {
                String key = this.getCookieAt(i);
                Cookie cookie = this.getCurrentCookie(key);
                String domain = cookie.getDomain();
                if ((host.equals(domain) || domain.startsWith(".") && host.endsWith(domain)) && path.startsWith(cookie.getPath())) {
                    cookies.add(cookie);
                }
                ++i;
            }
            cookieArray = cookies.toArray(NO_COOKIES);
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return NO_COOKIES;
            }
        }
        this._rwl.readLock().release();
        return cookieArray;
    }

    protected void fireCookieAdded(Cookie cookie) {
        Object[] listeners = this._listenerList.getListenerList();
        FrameworkEvent evt = new FrameworkEvent(this, cookie);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FrameworkListener.class) {
                try {
                    ((FrameworkListener)listeners[i + 1]).cookieAdded(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    protected void fireCookieRemoved(Cookie cookie) {
        Object[] listeners = this._listenerList.getListenerList();
        FrameworkEvent evt = new FrameworkEvent(this, cookie);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FrameworkListener.class) {
                try {
                    ((FrameworkListener)listeners[i + 1]).cookieRemoved(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    protected void fireCookiesChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FrameworkListener.class) {
                try {
                    ((FrameworkListener)listeners[i + 1]).cookiesChanged();
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    protected void fireConversationPropertyChanged(ConversationID id, String property) {
        Object[] listeners = this._listenerList.getListenerList();
        FrameworkEvent evt = new FrameworkEvent((Object)this, id, property);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FrameworkListener.class) {
                try {
                    ((FrameworkListener)listeners[i + 1]).conversationPropertyChanged(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    protected void fireUrlPropertyChanged(HttpUrl url, String property) {
        Object[] listeners = this._listenerList.getListenerList();
        FrameworkEvent evt = new FrameworkEvent((Object)this, url, property);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == FrameworkListener.class) {
                try {
                    ((FrameworkListener)listeners[i + 1]).urlPropertyChanged(evt);
                }
                catch (Exception e) {
                    this._logger.severe("Unhandled exception: " + e);
                }
            }
            i -= 2;
        }
    }

    private class FrameworkConversationModel
    extends AbstractConversationModel {
        public FrameworkConversationModel(FrameworkModel model) {
            super(model);
        }

        @Override
        public Sync readLock() {
            return FrameworkModel.this._rwl.readLock();
        }

        @Override
        public ConversationID getConversationAt(int index) {
            ConversationID conversationID;
            this.readLock().acquire();
            try {
                conversationID = FrameworkModel.this._store.getConversationAt(null, index);
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return null;
                }
            }
            this.readLock().release();
            return conversationID;
        }

        @Override
        public int getConversationCount() {
            int n;
            if (FrameworkModel.this._store == null) {
                return 0;
            }
            this.readLock().acquire();
            try {
                n = FrameworkModel.this._store.getConversationCount(null);
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return 0;
                }
            }
            this.readLock().release();
            return n;
        }

        @Override
        public int getIndexOfConversation(ConversationID id) {
            int n;
            this.readLock().acquire();
            try {
                n = FrameworkModel.this._store.getIndexOfConversation(null, id);
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return 0;
                }
            }
            this.readLock().release();
            return n;
        }
    }

    private class FrameworkUrlModel
    extends AbstractUrlModel {
        private FrameworkUrlModel() {
        }

        @Override
        public Sync readLock() {
            return FrameworkModel.this._rwl.readLock();
        }

        @Override
        public int getChildCount(HttpUrl parent) {
            int n;
            if (FrameworkModel.this._store == null) {
                return 0;
            }
            this.readLock().acquire();
            try {
                n = FrameworkModel.this._store.getChildCount(parent);
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return 0;
                }
            }
            this.readLock().release();
            return n;
        }

        @Override
        public int getIndexOf(HttpUrl url) {
            int n;
            this.readLock().acquire();
            try {
                n = FrameworkModel.this._store.getIndexOf(url);
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return -1;
                }
            }
            this.readLock().release();
            return n;
        }

        @Override
        public HttpUrl getChildAt(HttpUrl parent, int index) {
            HttpUrl httpUrl;
            this.readLock().acquire();
            try {
                httpUrl = FrameworkModel.this._store.getChildAt(parent, index);
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return null;
                }
            }
            this.readLock().release();
            return httpUrl;
        }
    }
}

