/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.owasp.webscarab.httpclient.Authenticator;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.httpclient.SSLContextManager;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.util.Glob;

public class URLFetcher
implements HTTPClient {
    private static SocketWatcher watcher = new SocketWatcher();
    private String _keyFingerprint = null;
    private SSLContextManager _sslContextManager = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private String _httpProxy = "";
    private int _httpProxyPort = -1;
    private String _httpsProxy = "";
    private int _httpsProxyPort = -1;
    private String[] _noProxy = new String[0];
    private Socket _socket = null;
    private boolean _direct = false;
    private Response _response = null;
    private InputStream _in = null;
    private OutputStream _out = null;
    private String _host = null;
    private int _port = 0;
    private long _lastRequestTime = 0L;
    private int _timeout = 0;
    private int _connectTimeout = 10000;
    private Authenticator _authenticator = null;
    private String _authCreds = null;
    private String _proxyAuthCreds = null;

    public void setHttpProxy(String proxy, int proxyport) {
        this._httpProxy = proxy;
        if (this._httpProxy == null) {
            this._httpProxy = "";
        }
        this._httpProxyPort = proxyport;
    }

    public void setHttpsProxy(String proxy, int proxyport) {
        this._httpsProxy = proxy;
        if (this._httpsProxy == null) {
            this._httpsProxy = "";
        }
        this._httpsProxyPort = proxyport;
    }

    public void setNoProxy(String[] noproxy) {
        if (noproxy == null) {
            this._noProxy = new String[0];
        } else if (noproxy.length == 0) {
            this._noProxy = noproxy;
        } else {
            this._noProxy = new String[noproxy.length];
            System.arraycopy(noproxy, 0, this._noProxy, 0, noproxy.length);
        }
    }

    public void setSSLContextManager(SSLContextManager sslContextManager) {
        this._sslContextManager = sslContextManager;
    }

    public void setTimeouts(int connectTimeout, int readTimeout) {
        this._connectTimeout = connectTimeout;
        this._timeout = readTimeout;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this._authenticator = authenticator;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    @Override
    public Response fetchResponse(Request request) throws IOException {
        String status;
        if (this._response != null) {
            this._response.flushContentStream();
            this._response = null;
        }
        if (request == null) {
            this._logger.severe("Asked to fetch a null request");
            return null;
        }
        HttpUrl url = request.getURL();
        if (url == null) {
            this._logger.severe("Asked to fetch a request with a null URL");
            return null;
        }
        if (this._authCreds != null && !this._authCreds.startsWith("Basic")) {
            this._lastRequestTime = 0L;
        }
        if (this._proxyAuthCreds != null && !this._proxyAuthCreds.startsWith("Basic")) {
            this._lastRequestTime = 0L;
        }
        this._authCreds = request.getHeader("Authorization");
        String keyFingerprint = request.getHeader("X-SSLClientCertificate");
        request.deleteHeader("X-SSLClientCertificate");
        if (!(keyFingerprint == null && this._keyFingerprint == null || keyFingerprint != null && this._keyFingerprint != null && keyFingerprint.equals(this._keyFingerprint))) {
            this._keyFingerprint = keyFingerprint;
            this._lastRequestTime = 0L;
        }
        String oldProxyAuthHeader = null;
        if (this._proxyAuthCreds == null && this._authenticator != null && this.useProxy(url)) {
            this._proxyAuthCreds = this._authenticator.getProxyCredentials(url.toString().startsWith("https") ? this._httpsProxy : this._httpProxy, null);
        }
        String proxyAuthHeader = this.constructAuthenticationHeader(null, this._proxyAuthCreds);
        String oldAuthHeader = null;
        if (this._authCreds == null && this._authenticator != null) {
            this._authCreds = this._authenticator.getCredentials(url, null);
        }
        String authHeader = this.constructAuthenticationHeader(null, this._authCreds);
        int tries = 0;
        do {
            String[] challenges;
            request.deleteHeader("Authorization");
            request.deleteHeader("Proxy-Authorization");
            this._response = null;
            this.connect(url);
            if (this._response != null) {
                return this._response;
            }
            if (authHeader != null) {
                request.setHeader("Authorization", authHeader);
                if (authHeader.startsWith("NTLM") || authHeader.startsWith("Negotiate")) {
                    if (request.getVersion().equals("HTTP/1.0")) {
                        request.setHeader("Connection", "Keep-Alive");
                    } else {
                        request.deleteHeader("Connection");
                    }
                }
            }
            if (this._direct) {
                request.writeDirect(this._out);
            } else {
                if (proxyAuthHeader != null) {
                    request.setHeader("Proxy-Authorization", proxyAuthHeader);
                    if (proxyAuthHeader.startsWith("NTLM") || proxyAuthHeader.startsWith("Negotiate")) {
                        if (request.getVersion().equals("HTTP/1.0")) {
                            request.setHeader("Connection", "Keep-Alive");
                        } else {
                            request.deleteHeader("Connection");
                        }
                    }
                }
                request.write(this._out);
            }
            this._out.flush();
            this._logger.finest("Request : \n" + request.toString());
            this._response = new Response();
            this._response.setRequest(request);
            this._logger.fine("Reading the response");
            do {
                this._response.read(this._in);
            } while ((status = this._response.getStatus()).equals("100"));
            StringBuffer buff = new StringBuffer();
            buff.append(this._response.getStatusLine()).append("\n");
            NamedValue[] headers = this._response.getHeaders();
            if (headers != null) {
                int i = 0;
                while (i < headers.length) {
                    buff.append(headers[i].getName()).append(": ").append(headers[i].getValue()).append("\n");
                    ++i;
                }
            }
            this._logger.finest("Response:\n" + buff.toString());
            if (status.equals("407")) {
                this._response.flushContentStream();
                oldProxyAuthHeader = proxyAuthHeader;
                challenges = this._response.getHeaders("Proxy-Authenticate");
                if (this._proxyAuthCreds == null && this._authenticator != null) {
                    this._proxyAuthCreds = this._authenticator.getProxyCredentials(this._httpProxy, challenges);
                }
                if ((proxyAuthHeader = this.constructAuthenticationHeader(challenges, this._proxyAuthCreds)) != null && oldProxyAuthHeader != null && oldProxyAuthHeader.equals(proxyAuthHeader)) {
                    this._logger.info("No possible authentication");
                    proxyAuthHeader = null;
                }
            }
            if (status.equals("401")) {
                this._response.flushContentStream();
                oldAuthHeader = authHeader;
                challenges = this._response.getHeaders("WWW-Authenticate");
                if (this._authCreds == null && this._authenticator != null) {
                    this._authCreds = this._authenticator.getCredentials(url, challenges);
                }
                this._logger.finer("Auth creds are " + this._authCreds);
                authHeader = this.constructAuthenticationHeader(challenges, this._authCreds);
                this._logger.finer("Auth header is " + authHeader);
                if (authHeader != null && oldAuthHeader != null && oldAuthHeader.equals(authHeader)) {
                    this._logger.info("No possible authentication");
                    authHeader = null;
                }
            }
            if (request.getMethod().equals("HEAD")) {
                this._response.setNoBody();
            }
            this._logger.info(String.valueOf(request.getMethod()) + " " + request.getURL() + " -> " + this._response.getStatusLine());
            String connection = this._response.getHeader("Proxy-Connection");
            if (connection != null && "close".equalsIgnoreCase(connection)) {
                this._in = null;
                this._out = null;
                continue;
            }
            connection = this._response.getHeader("Connection");
            String version = request.getVersion();
            if (version.equals("HTTP/1.0") && "Keep-alive".equalsIgnoreCase(connection)) {
                this._lastRequestTime = System.currentTimeMillis();
                continue;
            }
            if (version.equals("HTTP/1.1") && (connection == null || !connection.equalsIgnoreCase("Close"))) {
                this._lastRequestTime = System.currentTimeMillis();
                continue;
            }
            this._in = null;
            this._out = null;
        } while (++tries < 3 && (status.equals("401") && authHeader != null || status.equals("407") && proxyAuthHeader != null));
        if (this._authCreds != null) {
            request.setHeader("Authorization", this._authCreds);
        }
        request.deleteHeader("Proxy-Authorization");
        if (this._keyFingerprint != null) {
            request.setHeader("X-SSLClientCertificate", this._keyFingerprint);
        }
        return this._response;
    }

    private void connect(HttpUrl url) throws IOException {
        if (!this.invalidSocket(url)) {
            return;
        }
        this._logger.fine("Opening a new connection");
        this._socket = new Socket();
        this._socket.setSoTimeout(this._timeout);
        this._direct = true;
        this._host = url.getHost();
        this._port = url.getPort();
        boolean ssl = url.getScheme().equalsIgnoreCase("https");
        if (this.useProxy(url)) {
            if (!ssl) {
                this._logger.fine("Connect to " + this._httpProxy + ":" + this._httpProxyPort);
                this._socket.connect(new InetSocketAddress(this._httpProxy, this._httpProxyPort), this._connectTimeout);
                this._in = this._socket.getInputStream();
                this._out = this._socket.getOutputStream();
                this._direct = false;
            } else {
                String status;
                this._socket.connect(new InetSocketAddress(this._httpsProxy, this._httpsProxyPort), this._connectTimeout);
                this._in = this._socket.getInputStream();
                this._out = this._socket.getOutputStream();
                String oldAuthHeader = null;
                String authHeader = this.constructAuthenticationHeader(null, this._proxyAuthCreds);
                do {
                    this._out.write(("CONNECT " + this._host + ":" + this._port + " HTTP/1.0\r\n").getBytes());
                    if (authHeader != null) {
                        this._out.write(("Proxy-Authorization: " + authHeader + "\r\n").getBytes());
                    }
                    this._out.write("\r\n".getBytes());
                    this._out.flush();
                    this._logger.fine("Sent CONNECT, reading Proxy response");
                    Response response = new Response();
                    response.read(this._in);
                    this._logger.fine("Got proxy response " + response.getStatusLine());
                    status = response.getStatus();
                    if (!status.equals("407")) continue;
                    response.flushContentStream();
                    oldAuthHeader = authHeader;
                    String[] challenges = response.getHeaders("Proxy-Authenticate");
                    if (this._proxyAuthCreds == null && this._authenticator != null) {
                        this._proxyAuthCreds = this._authenticator.getProxyCredentials(this._httpsProxy, challenges);
                    }
                    if (this._proxyAuthCreds == null) {
                        this._response = response;
                        return;
                    }
                    authHeader = this.constructAuthenticationHeader(challenges, this._proxyAuthCreds);
                    if (authHeader != null && (oldAuthHeader == null || !oldAuthHeader.equals(authHeader))) continue;
                    this._response = response;
                    return;
                } while (status.equals("407") && authHeader != null);
                this._logger.fine("HTTPS CONNECT successful");
            }
        } else {
            this._logger.fine("Connect to " + this._host + ":" + this._port);
            this._socket.connect(new InetSocketAddress(this._host, this._port), this._connectTimeout);
        }
        if (ssl) {
            if (this._keyFingerprint == null) {
                this._keyFingerprint = this._sslContextManager.getDefaultKey();
            }
            this._logger.fine("Key fingerprint is " + this._keyFingerprint);
            SSLContext sslContext = this._sslContextManager.getSSLContext(this._keyFingerprint);
            if (sslContext == null) {
                throw new IOException("No SSL cert found matching fingerprint: " + this._keyFingerprint);
            }
            try {
                SSLSocketFactory factory = sslContext.getSocketFactory();
                SSLSocket sslsocket = (SSLSocket)factory.createSocket(this._socket, this._socket.getInetAddress().getHostName(), this._socket.getPort(), true);
                sslsocket.setUseClientMode(true);
                this._socket = sslsocket;
                this._socket.setSoTimeout(this._timeout);
            }
            catch (IOException ioe) {
                this._logger.severe("Error layering SSL over the existing socket: " + ioe);
                throw ioe;
            }
            this._logger.fine("Finished negotiating SSL");
        }
        this._in = this._socket.getInputStream();
        this._out = this._socket.getOutputStream();
    }

    private boolean useProxy(HttpUrl url) {
        String host = url.getHost();
        boolean ssl = url.getScheme().equalsIgnoreCase("https");
        if (ssl && "".equals(this._httpsProxy)) {
            return false;
        }
        if (!ssl && "".equals(this._httpProxy)) {
            return false;
        }
        int i = 0;
        while (i < this._noProxy.length) {
            if (this._noProxy[i].startsWith(".") && host.endsWith(this._noProxy[i])) {
                return false;
            }
            if (this._noProxy[i].equals("<local>") && host.indexOf(46) < 0) {
                return false;
            }
            if (host.equals(this._noProxy[i])) {
                return false;
            }
            try {
                if (host.matches(Glob.globToRE(this._noProxy[i]))) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return true;
    }

    private boolean invalidSocket(HttpUrl url) {
        if (this._host == null || this._in == null) {
            return true;
        }
        if (url.getHost().equals(this._host)) {
            int urlport = url.getPort();
            if (urlport == this._port) {
                long now = System.currentTimeMillis();
                if (now - this._lastRequestTime > 1000L) {
                    this._logger.fine("Socket has expired (" + (now - this._lastRequestTime) + "), open a new one!");
                    return true;
                }
                if (this._socket.isOutputShutdown() || this._socket.isClosed()) {
                    this._logger.fine("Existing socket is closed");
                    return true;
                }
                this._logger.fine("Existing socket is valid, reusing it!");
                return false;
            }
            this._logger.fine("Previous request was to a different port");
        } else {
            this._logger.fine("Previous request was to a different host");
        }
        return true;
    }

    private String constructAuthenticationHeader(String[] challenges, String credentials) {
        if (credentials == null) {
            return null;
        }
        if (credentials.startsWith("Basic")) {
            return credentials;
        }
        if (challenges != null) {
            int i = 0;
            while (i < challenges.length) {
                this._logger.fine("Challenge: " + challenges[i]);
                if (challenges[i].startsWith("Negotiate") && credentials.startsWith("Negotiate")) {
                    this._logger.fine("Attempting 'Negotiate' Authentication");
                }
                this._logger.info("Can't do auth for " + challenges[i]);
                ++i;
            }
        }
        return null;
    }

    private static class SocketWatcher {
        private Map sockets = new HashMap();

        public synchronized void add(Socket socket) {
            Iterator it = this.sockets.keySet().iterator();
            while (it.hasNext()) {
                Socket sock = (Socket)it.next();
                Thread thread = (Thread)this.sockets.get(sock);
                if (thread.isAlive() || !sock.isConnected()) continue;
                try {
                    sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                it.remove();
            }
            this.sockets.put(socket, Thread.currentThread());
        }
    }
}

