/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester.report;

import java.io.File;
import java.io.IOException;
import org.owasp.csrftester.CSRFTesterModel;
import org.owasp.csrftester.report.ReportAdapter;

public final class LinkReport
extends ReportAdapter {
    protected LinkReport() {
    }

    @Override
    public String generateHtml(CSRFTesterModel model, File dir) throws IOException {
        String html = this.getLinkHtml(model);
        String content = this.getContent("/resources/LinkTemplate.html");
        content = content.replace("<%LINK%>", html);
        this.writeFile(dir, "index.html", content);
        return "file://" + dir.getPath() + "/index.html";
    }

    private String getLinkHtml(CSRFTesterModel model) {
        String url = model.getURL(0);
        String parameters = model.getParameters(0);
        String linkText = model.getLinkText();
        StringBuffer sb = new StringBuffer();
        sb.append("<a href=\"");
        sb.append(model.getURL(0));
        if (url.indexOf(63) != -1) {
            sb.append('&');
            sb.append(parameters);
        } else {
            sb.append('?');
            sb.append(parameters);
        }
        sb.append("\"/>");
        sb.append(linkText);
        sb.append("</a>");
        return sb.toString();
    }
}

