/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester.report;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.owasp.csrftester.CSRFTesterModel;
import org.owasp.csrftester.report.ReportAdapter;

public class IMGReport
extends ReportAdapter {
    protected IMGReport() {
    }

    @Override
    public String generateHtml(CSRFTesterModel model, File dir) throws IOException {
        String[] locations = this.getLocations(model);
        String html = this.getImgHtml(locations);
        String content = this.getContent("/resources/IMGTemplate.html");
        content = content.replace("<%ATTACK%>", html);
        this.writeFile(dir, "index.html", content);
        return "file://" + dir.getPath() + "/index.html";
    }

    private String getImgHtml(String[] locations) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < locations.length) {
            sb.append("<img src=\"" + locations[i] + "\" width=\"0\" height=\"0\" border=\"0\"/>\r\n");
            ++i;
        }
        return sb.toString();
    }

    private String[] getLocations(CSRFTesterModel model) throws IOException {
        ArrayList<String> array = new ArrayList<String>();
        int q = 63;
        int amp = 38;
        int i = 0;
        while (i < model.getRowCount()) {
            StringBuffer sb = new StringBuffer();
            String url = model.getURL(i);
            String params = model.getParameters(i);
            sb.append(url);
            if (url.indexOf(63) != -1) {
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append(params);
            array.add(sb.toString());
            ++i;
        }
        String[] locations = new String[array.size()];
        return array.toArray(locations);
    }
}

