/*
 * Decompiled with CFR 0.152.
 */
package com.cookiecadger;

import com.cookiecadger.EnhancedJListItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;

public class EnhancedJList
extends JList {
    private Color[] rowColors = new Color[2];
    private boolean drawStripes = false;
    private ArrayList<String> highlightStrings = new ArrayList();
    private ArrayList<Color> highlightColors = new ArrayList();
    private RendererWrapper wrapper = null;

    public EnhancedJList() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Rectangle cellRect;
                EnhancedJList theList = (EnhancedJList)e.getSource();
                ListModel model = theList.getModel();
                Point mousePosition = e.getPoint();
                int index = theList.locationToIndex(mousePosition);
                if (index > -1 && (double)mousePosition.x >= (cellRect = theList.getCellBounds(index, index)).getMinX() && (double)mousePosition.x < cellRect.getMaxX() && (double)mousePosition.y >= cellRect.getMinY() && (double)mousePosition.y < cellRect.getMaxY()) {
                    theList.setToolTipText(((EnhancedJListItem)model.getElementAt(index)).getDescription());
                    return;
                }
                theList.setToolTipText(null);
            }
        });
    }

    public EnhancedJList(ListModel dataModel) {
        super(dataModel);
    }

    public EnhancedJList(Object[] listData) {
        super(listData);
    }

    public EnhancedJList(Vector<?> listData) {
        super(listData);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return super.getToolTipText();
    }

    public void performHighlight(final String textToMatchAgainst, Color color) {
        if (this.highlightStrings.contains(textToMatchAgainst)) {
            return;
        }
        this.highlightStrings.add(textToMatchAgainst);
        this.highlightColors.add(color);
        SwingWorker worker = new SwingWorker(){

            public Object doInBackground() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public void done() {
                EnhancedJList.this.highlightColors.remove(EnhancedJList.this.highlightStrings.indexOf(textToMatchAgainst));
                EnhancedJList.this.highlightStrings.remove(EnhancedJList.this.highlightStrings.indexOf(textToMatchAgainst));
                EnhancedJList.this.repaint();
            }
        };
        worker.execute();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            boolean bl = this.drawStripes = this.getLayoutOrientation() == 0 && this.isOpaque();
            if (!this.drawStripes) {
                super.paintComponent(g);
                return;
            }
            this.updateZebraColors();
            Insets insets = this.getInsets();
            int w = this.getWidth() - insets.left - insets.right;
            int h = this.getHeight() - insets.top - insets.bottom;
            int x = insets.left;
            int y = insets.top;
            int nRows = 0;
            int startRow = 0;
            int rowHeight = this.getFixedCellHeight();
            if (rowHeight > 0) {
                nRows = h / rowHeight;
            } else {
                int nItems = this.getModel().getSize();
                rowHeight = 17;
                int i = 0;
                while (i < nItems) {
                    rowHeight = this.getCellBounds((int)i, (int)i).height;
                    g.setColor(this.rowColors[i & 1]);
                    g.fillRect(x, y, w, rowHeight);
                    ++i;
                    y += rowHeight;
                }
                if (rowHeight > 0) {
                    nRows = nItems + (insets.top + h - y) / rowHeight;
                    startRow = nItems;
                }
            }
            int i = startRow;
            while (i < nRows) {
                g.setColor(this.rowColors[i & 1]);
                g.fillRect(x, y, w, rowHeight);
                ++i;
                y += rowHeight;
            }
            int remainder = insets.top + h - y;
            if (remainder > 0) {
                g.setColor(this.rowColors[nRows & 1]);
                g.fillRect(x, y, w, remainder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setOpaque(false);
        super.paintComponent(g);
        this.setOpaque(true);
    }

    public ListCellRenderer getCellRenderer() {
        ListCellRenderer ren = super.getCellRenderer();
        if (ren == null) {
            return null;
        }
        if (this.wrapper == null) {
            this.wrapper = new RendererWrapper();
        }
        this.wrapper.ren = ren;
        return this.wrapper;
    }

    private void updateZebraColors() {
        this.rowColors[0] = this.getBackground();
        if (this.rowColors[0] == null) {
            this.rowColors[0] = this.rowColors[1] = Color.white;
            return;
        }
        Color sel = this.getSelectionBackground();
        if (sel == null) {
            this.rowColors[1] = this.rowColors[0];
            return;
        }
        float[] bgHSB = Color.RGBtoHSB(this.rowColors[0].getRed(), this.rowColors[0].getGreen(), this.rowColors[0].getBlue(), null);
        float[] selHSB = Color.RGBtoHSB(sel.getRed(), sel.getGreen(), sel.getBlue(), null);
        this.rowColors[1] = Color.getHSBColor((double)selHSB[1] == 0.0 || (double)selHSB[2] == 0.0 ? bgHSB[0] : selHSB[0], 0.1f * selHSB[1] + 0.9f * bgHSB[1], bgHSB[2] + (bgHSB[2] < 0.5f ? 0.05f : -0.05f));
    }

    private class RendererWrapper
    implements ListCellRenderer {
        public ListCellRenderer ren = null;

        private RendererWrapper() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.ren.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (isSelected) {
                c.setBackground(Color.LIGHT_GRAY);
            } else if (EnhancedJList.this.drawStripes) {
                c.setBackground(EnhancedJList.this.rowColors[index & 1]);
            }
            if (value != null) {
                try {
                    String strVal = ((EnhancedJListItem)value).toString();
                    if (EnhancedJList.this.highlightStrings.contains(strVal)) {
                        int colorIndex = EnhancedJList.this.highlightStrings.indexOf(strVal);
                        c.setForeground((Color)EnhancedJList.this.highlightColors.get(colorIndex));
                    } else {
                        c.setForeground(Color.BLACK);
                    }
                    if (((EnhancedJListItem)value).hasThumbnail()) {
                        JLabel itemLabel = (JLabel)c;
                        ImageIcon icon = new ImageIcon(((EnhancedJListItem)value).getThumbnail());
                        itemLabel.setIcon(icon);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return c;
        }
    }
}

