/*
 *
 * Atention! Conn_config.h file is not editable! Edit Conn_config.h.in instead!
 *
 */

#define CONN_VERSION "1.0.39"
#define POLL_FOUND 1
#define EPOLL_FOUND 1

#define _GNU_SOURCE


/*
 * How many events slots to expect from kernel in one epoll_wait call
 */
#define CONN_EVENTS_SLOTS	256

/*
 * How many Conn structures to allocate once
 */
#define CONN_BULK_ALLOC		256

#if GCC_VERSION >= 40300
#define __hot		__attribute__((__hot__))
#define __cold		__attribute__((__cold__))
#else
#define __hot
#define __cold
#endif

/* Stolen from Linux kernel */
#define likely(x)	(__builtin_constant_p(x) ? !!(x) : __builtin_expect(!!(x), 1))
#define unlikely(x)	(__builtin_constant_p(x) ? !!(x) : __builtin_expect(!!(x), 0))
