#!/usr/bin/env node

// Generated by CoffeeScript 1.12.7
(function() {
  var _, net, optimist, punycode, socks, util;

  _ = require('underscore');

  net = require('net');

  socks = require('socks');

  punycode = require('punycode');

  util = require('util');

  this.SERVERS = require('./servers.json');

  this.lookup = (function(_this) {
    return function(addr, options, done) {
      var _lookup, parts, proxy, server, sockOpts, socket, timeout, tld;
      if (typeof done === 'undefined' && typeof options === 'function') {
        done = options;
        options = {};
      }
      _.defaults(options, {
        follow: 2,
        timeout: 60000
      });
      done = _.once(done);
      server = options.server;
      proxy = options.proxy;
      timeout = options.timeout;
      if (!server) {
        switch (true) {
          case _.contains(addr, '@'):
            done(new Error('lookup: email addresses not supported'));
            return;
          case net.isIP(addr) !== 0:
            server = _this.SERVERS['_']['ip'];
            break;
          default:
            tld = punycode.toASCII(addr);
            while (true) {
              server = _this.SERVERS[tld];
              if (!tld || server) {
                break;
              }
              tld = tld.replace(/^.+?(\.|$)/, '');
            }
        }
      }
      if (!server) {
        done(new Error('lookup: no whois server is known for this kind of object'));
        return;
      }
      if (typeof server === 'string') {
        parts = server.split(':');
        server = {
          host: parts[0],
          port: parts[1]
        };
      }
      if (typeof proxy === 'string') {
        parts = proxy.split(':');
        proxy = {
          ipaddress: parts[0],
          port: parseInt(parts[1])
        };
      }
      _.defaults(server, {
        port: 43,
        query: "$addr\r\n"
      });
      if (proxy) {
        _.defaults(proxy, {
          type: 5
        });
      }
      _lookup = function(socket, done) {
        var data, idn;
        idn = addr;
        if (server.punycode !== false && options.punycode !== false) {
          idn = punycode.toASCII(addr);
        }
        socket.write(server.query.replace('$addr', idn));
        data = '';
        socket.on('data', function(chunk) {
          return data += chunk;
        });
        socket.on('timeout', function() {
          socket.destroy();
          return done(new Error('lookup: timeout'));
        });
        socket.on('error', function(err) {
          return done(err);
        });
        return socket.on('close', function(err) {
          var match;
          if (options.follow > 0) {
            match = data.replace(/\r/gm, '').match(/(ReferralServer|Registrar Whois|Whois Server|WHOIS Server|Registrar WHOIS Server):[^\S\n]*((?:r?whois|https?):\/\/)?(.*)/);
            if ((match != null) && match[3] !== server.host) {
              options = _.extend({}, options, {
                follow: options.follow - 1,
                server: match[3]
              });
              _this.lookup(addr, options, function(err, parts) {
                if (err != null) {
                  return done(err);
                }
                if (options.verbose) {
                  return done(null, [
                    {
                      server: server,
                      data: data
                    }
                  ].concat(parts));
                } else {
                  return done(null, parts);
                }
              });
              return;
            }
          }
          if (options.verbose) {
            return done(null, [
              {
                server: server,
                data: data
              }
            ]);
          } else {
            return done(null, data);
          }
        });
      };
      if (proxy) {
        return socks.createConnection({
          proxy: proxy,
          target: {
            host: server.host,
            port: server.port
          },
          timeout: timeout
        }, function(err, socket, info) {
          if (err != null) {
            return done(err);
          }
          _lookup(socket, done);
          return socket.resume();
        });
      } else {
        sockOpts = {
          host: server.host,
          port: server.port
        };
        if (options.bind) {
          sockOpts.localAddress = options.bind;
        }
        socket = net.connect(sockOpts);
        if (timeout) {
          socket.setTimeout(timeout);
        }
        return _lookup(socket, done);
      }
    };
  })(this);

  if (module === require.main) {
    optimist = require('optimist').usage('$0 [options] address')["default"]('s', null).alias('s', 'server').describe('s', 'whois server')["default"]('f', 0).alias('f', 'follow').describe('f', 'number of times to follow redirects')["default"]('p', null).alias('p', 'proxy').describe('p', 'SOCKS proxy').boolean('v')["default"]('v', false).alias('v', 'verbose').describe('v', 'show verbose results')["default"]('b', null).alias('b', 'bind').describe('b', 'bind to a local IP address').boolean('h')["default"]('h', false).alias('h', 'help').describe('h', 'display this help message');
    if (optimist.argv.h) {
      console.log(optimist.help());
      process.exit(0);
    }
    if (optimist.argv._[0] == null) {
      console.log(optimist.help());
      process.exit(1);
    }
    this.lookup(optimist.argv._[0], {
      server: optimist.argv.server,
      follow: optimist.argv.follow,
      proxy: optimist.argv.proxy,
      verbose: optimist.argv.verbose,
      bind: optimist.argv.bind
    }, (function(_this) {
      return function(err, data) {
        var i, len, part, results;
        if (err != null) {
          console.log(err);
          process.exit(1);
        }
        if (util.isArray(data)) {
          results = [];
          for (i = 0, len = data.length; i < len; i++) {
            part = data[i];
            console.log(part.server.host);
            console.log(part.data);
            results.push(console.log);
          }
          return results;
        } else {
          return console.log(data);
        }
      };
    })(this));
  }

}).call(this);
