// Copyright Jesus Perez <jesusprubio gmail com>
//           Sergio Garcia <s3rgio.gr gmail com>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

'use strict';


const ExploitSearch = require('exploitsearch');

module.exports.help = {
  description: 'Find vulnerabilities and exploit for an specifig service version'
  + '(using exploitsearch.net API)',
  options: {
    query: {
      type: 'allValid',
      description: 'String to search',
      defaultValue: 'Apache 7.4',
    },
    timeout: {
      type: 'positiveInt',
      description: 'Time to wait for a response (ms)',
      defaultValue: 5000,
    },
    onlyExploits: {
      type: 'yesNo',
      description: 'Look only for exploits, not vulns',
      defaultValue: 'no',
    },
  },
};


module.exports.run = (options, callback) => {
  const reqOptions = {
    timeout: parseInt(options.timeout, 10),
    onlyExploits: options.timeout,
  };

  const client = new ExploitSearch(reqOptions);
  client.search(options.query, callback);
};
