/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.net.proxy.thread;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public abstract class ProxyThread
extends Thread {
    private static final int PROXY_THREAD_JOIN_TIMEOUT = 5300;
    protected volatile Socket _sourceSocket;
    protected volatile Socket _destSocket;
    protected volatile boolean _shutdown;

    public ProxyThread(Socket srcSocket, Socket dstSocket) {
        this._sourceSocket = srcSocket;
        this._destSocket = dstSocket;
        this._shutdown = false;
    }

    @Override
    public void run() {
        block6: {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(8192);
            byte[] readBuffer = new byte[8192];
            try {
                int readLength;
                InputStream inStream = this._sourceSocket.getInputStream();
                OutputStream outStream = this._destSocket.getOutputStream();
                while (!this._shutdown && (readLength = inStream.read(readBuffer, 0, 8192)) != -1) {
                    byteStream.reset();
                    byteStream.write(readBuffer, 0, readLength);
                    outStream.write(this.handleData(byteStream).toByteArray());
                }
            }
            catch (IOException ex) {
                if (!(ex.getMessage().equals("Socket Closed") || ex.getMessage().equals("Connection reset") || ex.getMessage().equals("Read timed out"))) {
                    System.out.println("[-] An exception occurred during the " + this.getClass().getSimpleName() + " main loop.\n\t" + ex.toString());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                if (this._shutdown) break block6;
                this.shutdown();
            }
        }
    }

    public final void shutdown() {
        this.shutdown(false);
    }

    public final void shutdown(boolean force) {
        if (!this._shutdown) {
            this._shutdown = true;
            if (force) {
                if (this._sourceSocket != null) {
                    try {
                        this._sourceSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this._sourceSocket = null;
                }
                if (this._destSocket != null) {
                    try {
                        this._destSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this._destSocket = null;
                }
                if (this.isAlive()) {
                    this.interrupt();
                }
            } else {
                try {
                    this.join(5300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isAlive()) {
                    this.interrupt();
                }
                if (this._sourceSocket != null) {
                    try {
                        this._sourceSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this._sourceSocket = null;
                }
                if (this._destSocket != null) {
                    try {
                        this._destSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this._destSocket = null;
                }
            }
            this.handleShutdown(force);
        }
    }

    public void handleShutdown(boolean force) {
    }

    public abstract ByteArrayOutputStream handleData(ByteArrayOutputStream var1);
}

