/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.net.proxy.thread;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import nb.barmie.net.proxy.RMIMethodCallProxy;
import nb.barmie.net.proxy.thread.ProxyThread;
import nb.barmie.util.ProgramOptions;

public class ObjectRedirectProxyThread
extends ProxyThread {
    private final ProgramOptions _options;
    private final byte[] _payload;
    private final byte[] _marker;
    private volatile ArrayList<RMIMethodCallProxy> _methodProxies;

    public ObjectRedirectProxyThread(Socket srcSocket, Socket dstSocket, ProgramOptions options, byte[] payload, byte[] marker) {
        super(srcSocket, dstSocket);
        this._options = options;
        this._payload = payload;
        this._marker = marker;
        this._methodProxies = new ArrayList();
    }

    @Override
    public ByteArrayOutputStream handleData(ByteArrayOutputStream data) {
        ByteArrayOutputStream outData = new ByteArrayOutputStream();
        byte[] dataBytes = data.toByteArray();
        for (int i = 0; i < dataBytes.length; ++i) {
            outData.write(dataBytes[i]);
            try {
                int portNumber;
                String hostName;
                int hostLen;
                int j;
                if (dataBytes[i] != 119) continue;
                int blockLen = dataBytes[i + 1];
                if (dataBytes[i + 2] != 0) continue;
                StringBuilder sb = new StringBuilder(dataBytes[i + 3]);
                for (j = 0; j < dataBytes[i + 3]; ++j) {
                    sb.append((char)dataBytes[i + j + 4]);
                }
                String refType = sb.toString();
                if (refType.equals("UnicastRef")) {
                    hostLen = (dataBytes[i + 14] << 8) + dataBytes[i + 15];
                    sb = new StringBuilder(hostLen);
                    for (j = 0; j < hostLen; ++j) {
                        sb.append((char)dataBytes[i + j + 16]);
                    }
                    hostName = sb.toString();
                    portNumber = (dataBytes[i + hostLen + 16] << 24 & 0xFF000000) + (dataBytes[i + hostLen + 17] << 16 & 0xFF0000) + (dataBytes[i + hostLen + 18] << 8 & 0xFF00) + (dataBytes[i + hostLen + 19] & 0xFF);
                } else {
                    if (!refType.equals("UnicastRef2")) continue;
                    hostLen = (dataBytes[i + 16] << 8) + dataBytes[i + 17];
                    sb = new StringBuilder(hostLen);
                    for (j = 0; j < hostLen; ++j) {
                        sb.append((char)dataBytes[i + j + 18]);
                    }
                    hostName = sb.toString();
                    portNumber = (dataBytes[i + hostLen + 18] << 24 & 0xFF000000) + (dataBytes[i + hostLen + 19] << 16 & 0xFF0000) + (dataBytes[i + hostLen + 20] << 8 & 0xFF00) + (dataBytes[i + hostLen + 21] & 0xFF);
                }
                try {
                    RMIMethodCallProxy proxy = new RMIMethodCallProxy(InetAddress.getByName(hostName), portNumber, this._options, this._payload, this._marker);
                    proxy.startProxy();
                    this._methodProxies.add(proxy);
                    String newHost = proxy.getServerListenAddress().getHostAddress();
                    int newPort = proxy.getServerListenPort();
                    outData.write((byte)(blockLen += newHost.length() - hostName.length()));
                    outData.write((byte)((refType.length() & 0xFF00) >> 8));
                    outData.write((byte)(refType.length() & 0xFF));
                    outData.write(refType.getBytes());
                    if (refType.equals("UnicastRef2")) {
                        outData.write(dataBytes[i + 15]);
                    }
                    outData.write((byte)((newHost.length() & 0xFF00) >> 8));
                    outData.write((byte)(newHost.length() & 0xFF));
                    outData.write(newHost.getBytes());
                    outData.write((byte)((newPort & 0xFF000000) >> 24));
                    outData.write((byte)((newPort & 0xFF0000) >> 16));
                    outData.write((byte)((newPort & 0xFF00) >> 8));
                    outData.write((byte)(newPort & 0xFF));
                    i = i + hostName.length() + 19;
                    if (!refType.equals("UnicastRef2")) continue;
                    i += 2;
                }
                catch (Exception ex) {
                    System.out.println("[-] An exception occurred whilst starting an RMI method call proxy.\n\t" + ex.toString());
                }
                continue;
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
        }
        return outData;
    }

    @Override
    public void handleShutdown(boolean force) {
        for (RMIMethodCallProxy proxy : this._methodProxies) {
            proxy.stopProxy(force);
        }
        this._methodProxies.clear();
    }
}

