/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.enumeration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import nb.barmie.exceptions.BaRMIeInvalidPortException;
import nb.barmie.exceptions.BaRMIeInvalidReplyDataPacketException;
import nb.barmie.modes.enumeration.RMIObject;
import nb.barmie.net.TCPEndpoint;

public class RMIReplyDataParser {
    private boolean _recordClasses = true;
    private LinkedList<HashMap<Byte, ArrayList<Character>>> _classDataDesc = new LinkedList();

    public RMIObject extractObjectDetails(String objName, ArrayList<Byte> packetBytes) {
        RMIObject obj = new RMIObject(objName);
        LinkedList<Byte> dataStack = new LinkedList<Byte>();
        dataStack.addAll(packetBytes);
        this._recordClasses = true;
        try {
            if ((Byte)dataStack.peek() != 81) {
                throw new BaRMIeInvalidReplyDataPacketException("The data buffer begins with 0x" + String.format("%02x", dataStack.peek()) + ", which is not a ReplyData packet (0x51 expected).");
            }
            dataStack.pop();
            if ((Byte)dataStack.pop() != -84 || (Byte)dataStack.pop() != -19) {
                throw new BaRMIeInvalidReplyDataPacketException("The data buffer does not contain the serialisation magic number data.");
            }
            if ((Byte)dataStack.pop() != 0 || (Byte)dataStack.pop() != 5) {
                throw new BaRMIeInvalidReplyDataPacketException("The data buffer does not contain version 5 serialisation data.");
            }
            block6: while (dataStack.size() > 0) {
                int b = ((Byte)dataStack.pop()).byteValue();
                switch (b) {
                    case 119: {
                        b = ((Byte)dataStack.pop()).byteValue();
                        for (int i = 0; i < b; ++i) {
                            dataStack.pop();
                        }
                        continue block6;
                    }
                    case 115: {
                        this.handleNewObjectElement(obj, dataStack);
                        continue block6;
                    }
                }
                throw new BaRMIeInvalidReplyDataPacketException("Unknown serialisation stream element (0x" + String.format("%02x", (byte)b) + ").");
            }
        }
        catch (Exception e) {
            obj.setParsingException(e);
        }
        return obj;
    }

    private void handleNewObjectElement(RMIObject obj, LinkedList<Byte> dataStack) throws BaRMIeInvalidReplyDataPacketException {
        this._classDataDesc.clear();
        this.handleClassDesc(obj, dataStack);
        this._recordClasses = false;
        LinkedList<HashMap<Byte, ArrayList<Character>>> classDataDesc = new LinkedList<HashMap<Byte, ArrayList<Character>>>();
        for (HashMap hashMap : this._classDataDesc) {
            HashMap classDataDescElement = new HashMap();
            for (Byte key : hashMap.keySet()) {
                ArrayList<Character> classDataDescFields = new ArrayList<Character>();
                for (Character typeCode : (ArrayList)hashMap.get(key)) {
                    classDataDescFields.add(typeCode);
                }
                classDataDescElement.put(key, classDataDescFields);
            }
            classDataDesc.add(classDataDescElement);
        }
        this.handleClassData(obj, dataStack, classDataDesc);
    }

    private void handleClassDesc(RMIObject obj, LinkedList<Byte> dataStack) throws BaRMIeInvalidReplyDataPacketException {
        switch (dataStack.pop()) {
            case 114: {
                String className = this.extractUtf8(dataStack);
                this.extractLong(dataStack);
                this.handleClassDescInfo(obj, dataStack, className);
                break;
            }
            case 125: {
                this.handleProxyClassDescInfo(obj, dataStack);
                break;
            }
            case 112: {
                break;
            }
            default: {
                throw new BaRMIeInvalidReplyDataPacketException("Unknown classDesc element type.");
            }
        }
    }

    private void handleClassDescInfo(RMIObject obj, LinkedList<Byte> dataStack, String className) throws BaRMIeInvalidReplyDataPacketException {
        byte classDescFlags = dataStack.pop();
        this.handleFields(obj, dataStack, classDescFlags);
        ArrayList<String> stringAnnotations = this.handleClassAnnotation(obj, dataStack);
        if (this._recordClasses) {
            obj.addClass(className);
            for (String annotation : stringAnnotations) {
                obj.addStringAnnotation(className, annotation);
            }
        }
        this.handleClassDesc(obj, dataStack);
    }

    private void handleProxyClassDescInfo(RMIObject obj, LinkedList<Byte> dataStack) throws BaRMIeInvalidReplyDataPacketException {
        int i;
        int interfaceCount = this.extractInt(dataStack);
        String[] interfaceNames = new String[interfaceCount];
        for (i = 0; i < interfaceCount; ++i) {
            interfaceNames[i] = this.extractUtf8(dataStack);
        }
        ArrayList<String> stringAnnotations = this.handleClassAnnotation(obj, dataStack);
        if (this._recordClasses) {
            for (i = 0; i < interfaceCount; ++i) {
                obj.addClass(interfaceNames[i]);
                if (i != 0) continue;
                for (String annotation : stringAnnotations) {
                    obj.addStringAnnotation(interfaceNames[i], annotation);
                }
            }
        }
        this.handleClassDesc(obj, dataStack);
    }

    private ArrayList<String> handleClassAnnotation(RMIObject obj, LinkedList<Byte> dataStack) throws BaRMIeInvalidReplyDataPacketException {
        byte b;
        ArrayList<String> stringAnnotations = new ArrayList<String>();
        block5: while ((b = dataStack.pop().byteValue()) != 120) {
            switch (b) {
                case 116: {
                    stringAnnotations.add(this.extractUtf8(dataStack));
                    continue block5;
                }
                case 113: {
                    this.extractInt(dataStack);
                    continue block5;
                }
                case 112: {
                    continue block5;
                }
            }
            throw new BaRMIeInvalidReplyDataPacketException("Unknown classAnnotation element type (0x" + String.format("%02x", b) + ").");
        }
        return stringAnnotations;
    }

    private void handleFields(RMIObject obj, LinkedList<Byte> dataStack, byte classDescFlags) throws BaRMIeInvalidReplyDataPacketException {
        ArrayList<Character> fieldTypeCodes = new ArrayList<Character>();
        int fieldCount = this.extractShort(dataStack);
        block4: for (int i = 0; i < fieldCount; ++i) {
            char typeCode = (char)dataStack.pop().byteValue();
            fieldTypeCodes.add(Character.valueOf(typeCode));
            switch (typeCode) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    this.extractUtf8(dataStack);
                    continue block4;
                }
                case 'L': 
                case '[': {
                    this.extractUtf8(dataStack);
                    this.handleStringElement(dataStack);
                    continue block4;
                }
                default: {
                    throw new BaRMIeInvalidReplyDataPacketException("Invalid field type code (0x" + String.format("%02x", (byte)typeCode) + ").");
                }
            }
        }
        HashMap<Byte, ArrayList<Character>> classDataDesc = new HashMap<Byte, ArrayList<Character>>();
        classDataDesc.put(classDescFlags, fieldTypeCodes);
        this._classDataDesc.push(classDataDesc);
    }

    private void handleStringElement(LinkedList<Byte> dataStack) throws BaRMIeInvalidReplyDataPacketException {
        switch (dataStack.pop()) {
            case 116: {
                this.extractUtf8(dataStack);
                break;
            }
            case 124: {
                this.extractLongUtf8(dataStack);
                break;
            }
            case 113: {
                this.extractInt(dataStack);
                break;
            }
            default: {
                throw new BaRMIeInvalidReplyDataPacketException("Invalid string element type.");
            }
        }
    }

    private void handleClassData(RMIObject obj, LinkedList<Byte> dataStack, LinkedList<HashMap<Byte, ArrayList<Character>>> classDataDesc) throws BaRMIeInvalidReplyDataPacketException {
        while (classDataDesc.size() > 0) {
            HashMap<Byte, ArrayList<Character>> desc = classDataDesc.pop();
            byte classDescFlags = (Byte)desc.keySet().toArray()[0];
            ArrayList<Character> fieldTypes = desc.get(classDescFlags);
            if ((classDescFlags & 2) == 2) {
                block15: for (Character typeCode : fieldTypes) {
                    switch (typeCode.charValue()) {
                        case 'D': 
                        case 'J': {
                            dataStack.pop();
                            dataStack.pop();
                            dataStack.pop();
                            dataStack.pop();
                        }
                        case 'F': 
                        case 'I': {
                            dataStack.pop();
                            dataStack.pop();
                        }
                        case 'S': {
                            dataStack.pop();
                        }
                        case 'B': 
                        case 'C': 
                        case 'Z': {
                            dataStack.pop();
                            continue block15;
                        }
                        case 'L': {
                            byte objType = dataStack.pop();
                            switch (objType) {
                                case 115: {
                                    this.handleNewObjectElement(obj, dataStack);
                                    continue block15;
                                }
                                case 116: {
                                    this.extractUtf8(dataStack);
                                    continue block15;
                                }
                                case 113: {
                                    this.extractInt(dataStack);
                                    continue block15;
                                }
                                case 112: {
                                    continue block15;
                                }
                            }
                            throw new BaRMIeInvalidReplyDataPacketException("Unexpected byte when handling an object field value.");
                        }
                        case '[': {
                            throw new BaRMIeInvalidReplyDataPacketException("Invalid field type code ([).");
                        }
                    }
                    throw new BaRMIeInvalidReplyDataPacketException("Invalid field type code (" + typeCode + ").");
                }
                if ((classDescFlags & 1) != 1) continue;
                this.handleObjectAnnotation(obj, dataStack);
                continue;
            }
            if ((classDescFlags & 4) != 4) continue;
            if ((classDescFlags & 8) == 8) {
                throw new BaRMIeInvalidReplyDataPacketException("Class data loading with SC_EXTERNALIZABLE and SC_BLOCK_DATA not implemented yet...");
            }
            throw new BaRMIeInvalidReplyDataPacketException("Class data loading with SC_EXTERNALIZABLE and !SC_BLOCK_DATA is class-specific and not available...");
        }
    }

    private void handleObjectAnnotation(RMIObject obj, LinkedList<Byte> dataStack) throws BaRMIeInvalidReplyDataPacketException {
        byte b;
        block5: while ((b = dataStack.pop().byteValue()) != 120) {
            switch (b) {
                case 119: {
                    dataStack.push((byte)119);
                    this.extractObjectEndpointFromBlockData(obj, dataStack);
                    continue block5;
                }
                case 115: {
                    this.handleNewObjectElement(obj, dataStack);
                    continue block5;
                }
                case 112: {
                    continue block5;
                }
            }
            throw new BaRMIeInvalidReplyDataPacketException("Unknown classAnnotation element type (0x" + String.format("%02x", b) + ").");
        }
    }

    private void extractObjectEndpointFromBlockData(RMIObject obj, LinkedList<Byte> dataStack) throws BaRMIeInvalidReplyDataPacketException {
        LinkedList<Byte> blockData = new LinkedList<Byte>();
        switch (dataStack.pop()) {
            case 119: {
                int blockSize = Byte.toUnsignedInt(dataStack.pop());
                for (int i = 0; i < blockSize; ++i) {
                    blockData.add(dataStack.pop());
                }
                break;
            }
            default: {
                throw new BaRMIeInvalidReplyDataPacketException("Invalid block data element type in class annotation.");
            }
        }
        if (this.peekShort(blockData) == 10) {
            if (this.extractUtf8(blockData).equals("UnicastRef")) {
                try {
                    obj.setObjectEndpoint(new TCPEndpoint(this.extractUtf8(blockData), this.extractInt(blockData)));
                }
                catch (BaRMIeInvalidPortException bipe) {
                    throw new BaRMIeInvalidReplyDataPacketException("UnicastRef contained an invalid port number.", bipe);
                }
            }
        } else if (this.peekShort(blockData) == 11 && this.extractUtf8(blockData).equals("UnicastRef2")) {
            try {
                blockData.pop();
                obj.setObjectEndpoint(new TCPEndpoint(this.extractUtf8(blockData), this.extractInt(blockData)));
            }
            catch (BaRMIeInvalidPortException bipe) {
                throw new BaRMIeInvalidReplyDataPacketException("UnicastRef contained an invalid port number.", bipe);
            }
        }
    }

    private short extractShort(LinkedList<Byte> dataStack) {
        return (short)((dataStack.pop() << 8 & 0xFF00) + (dataStack.pop() & 0xFF));
    }

    private short peekShort(LinkedList<Byte> dataStack) {
        return (short)((dataStack.get(0) << 8 & 0xFF00) + (dataStack.get(1) & 0xFF));
    }

    private int extractInt(LinkedList<Byte> dataStack) {
        return (dataStack.pop() << 24 & 0xFF000000) + (dataStack.pop() << 16 & 0xFF0000) + (dataStack.pop() << 8 & 0xFF00) + (dataStack.pop() & 0xFF);
    }

    private long extractLong(LinkedList<Byte> dataStack) {
        return ((long)(dataStack.pop() << 56) & 0xFF00000000000000L) + ((long)(dataStack.pop() << 48) & 0xFF000000000000L) + ((long)(dataStack.pop() << 40) & 0xFF0000000000L) + ((long)(dataStack.pop() << 32) & 0xFF00000000L) + (long)(dataStack.pop() << 24 & 0xFF000000) + (long)(dataStack.pop() << 16 & 0xFF0000) + (long)(dataStack.pop() << 8 & 0xFF00) + (long)(dataStack.pop() & 0xFF);
    }

    private String extractUtf8(LinkedList<Byte> dataStack) {
        int stringLength = Short.toUnsignedInt(this.extractShort(dataStack));
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < stringLength; ++i) {
            builder.append((char)dataStack.pop().byteValue());
        }
        return builder.toString();
    }

    private String extractLongUtf8(LinkedList<Byte> dataStack) {
        long stringLength = this.extractLong(dataStack);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while ((long)i < stringLength) {
            builder.append((char)dataStack.pop().byteValue());
            ++i;
        }
        return builder.toString();
    }
}

