/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.coverage.CoveragePattern;
import com.android.jack.util.NamingTools;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class CoveragePatternCodec
implements StringCodec<CoveragePattern> {
    @Nonnull
    public CoveragePattern parseString(@Nonnull CodecContext context, @Nonnull String string) {
        return new CoveragePattern(string);
    }

    @CheckForNull
    public CoveragePattern checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        if (!NamingTools.isClassSourceName((String)CoveragePatternCodec.fakeWildcards(string))) {
            throw new ParsingException("pattern '" + string + "' is not valid");
        }
        return this.parseString(context, string);
    }

    @Nonnull
    public String getUsage() {
        return "a fully-qualified java class name (e.g. java.lang.Object)";
    }

    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        ArrayList<Parser.ValueDescription> valueDescriptions = new ArrayList<Parser.ValueDescription>();
        valueDescriptions.add(new Parser.ValueDescription("*", "replaces multiple characters"));
        valueDescriptions.add(new Parser.ValueDescription("?", "replaces a single character"));
        return valueDescriptions;
    }

    @Nonnull
    public String getVariableName() {
        return "pattern";
    }

    @Nonnull
    public String formatValue(@Nonnull CoveragePattern data) {
        return data.getString();
    }

    public void checkValue(@Nonnull CodecContext context, @Nonnull CoveragePattern data) throws CheckingException {
        String string = data.getString();
        if (!NamingTools.isClassSourceName((String)CoveragePatternCodec.fakeWildcards(string))) {
            throw new CheckingException("pattern '" + string + "' is not valid");
        }
    }

    static String fakeWildcards(@Nonnull String string) {
        return string.replace('*', 'a').replace('?', 'b');
    }
}

