/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class CoveragePattern {
    @Nonnull
    private final String string;
    @Nonnull
    private final Pattern pattern;

    public CoveragePattern(@Nonnull String string) {
        this.string = string;
        StringBuilder sb = new StringBuilder();
        int e = string.length();
        for (int i = 0; i < e; ++i) {
            char c = string.charAt(i);
            if (c == '?' || c == '*') {
                sb.append('.');
                sb.append(c);
                continue;
            }
            sb.append(Pattern.quote(String.valueOf(c)));
        }
        this.pattern = Pattern.compile(sb.toString());
    }

    @Nonnull
    public String getString() {
        return this.string;
    }

    @Nonnull
    public Pattern getPattern() {
        return this.pattern;
    }

    public final boolean equals(@CheckForNull Object obj) {
        if (!(obj instanceof CoveragePattern)) {
            return false;
        }
        CoveragePattern other = (CoveragePattern)obj;
        return this.getString().equals(other.getString());
    }

    public final int hashCode() {
        return this.getString().hashCode();
    }

    @Nonnull
    public String toString() {
        return this.getString();
    }

    public boolean matchesAny(String string) {
        return this.getPattern().matcher(string).matches();
    }
}

