/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class GenericInputVFile
implements InputVFile {
    @Nonnull
    private final VFile file;

    public GenericInputVFile(@Nonnull VFile file) {
        this.file = file;
    }

    @Override
    public boolean isVDir() {
        return false;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.file.getName();
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.file.getLocation();
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws WrongPermissionException {
        return this.file.getInputStream();
    }

    @Override
    public void delete() throws CannotDeleteFileException {
        this.file.delete();
    }

    @CheckForNull
    public String getDigest() {
        return this.file.getDigest();
    }

    @Override
    @Nonnull
    public VPath getPathFromRoot() {
        return this.file.getPathFromRoot();
    }

    @Override
    @Nonnull
    public VFile getVFile() {
        return this.file;
    }

    @Override
    @Nonnull
    public FileTime getLastModified() throws CannotGetModificationTimeException {
        return this.file.getLastModified();
    }

    @Nonnull
    public String toString() {
        return this.file.toString();
    }
}

