/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.VDir;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;

abstract class BaseVDir
extends BaseVElement
implements VDir {
    public BaseVDir(@Nonnull BaseVFS<? extends BaseVDir, ? extends BaseVFile> vfs, @Nonnull String name) {
        super(vfs, name);
    }

    @Override
    @Nonnull
    public BaseVDir getVDir(@Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        return this.vfs.getVDir(this, name);
    }

    @Override
    @Nonnull
    public BaseVDir getVDir(@Nonnull VPath path) throws NotDirectoryException, NoSuchFileException {
        BaseVDir dir = this;
        for (String name : path.split()) {
            dir = dir.getVDir(name);
        }
        return dir;
    }

    @Override
    @Nonnull
    public BaseVFile getVFile(@Nonnull String name) throws NoSuchFileException, NotFileException {
        return this.vfs.getVFile(this, name);
    }

    @Override
    @Nonnull
    public BaseVFile getVFile(@Nonnull VPath path) throws NoSuchFileException, NotDirectoryException, NotFileException {
        BaseVDir dir = this;
        Iterator<String> iter = path.split().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (iter.hasNext()) {
                dir = dir.getVDir(name);
                continue;
            }
            return dir.getVFile(name);
        }
        throw new AssertionError();
    }

    @Override
    @Nonnull
    public void delete(@Nonnull VFile file) throws CannotDeleteFileException {
        this.vfs.delete((BaseVFile)file);
    }

    @Override
    @Nonnull
    public BaseVDir createVDir(@Nonnull VPath path) throws CannotCreateFileException {
        BaseVDir dir = this;
        for (String name : path.split()) {
            dir = dir.createVDir(name);
        }
        return dir;
    }

    @Override
    @Nonnull
    public BaseVFile createVFile(@Nonnull VPath path) throws CannotCreateFileException {
        BaseVDir dir = this;
        Iterator<String> iter = path.split().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (iter.hasNext()) {
                dir = dir.createVDir(name);
                continue;
            }
            return dir.createVFile(name);
        }
        throw new AssertionError();
    }

    @Nonnull
    public Collection<? extends BaseVElement> list() {
        return this.vfs.list(this);
    }

    @Override
    public boolean isEmpty() {
        return this.vfs.isEmpty(this);
    }

    @Override
    public boolean isVDir() {
        return true;
    }

    @Override
    @Nonnull
    public BaseVDir createVDir(@Nonnull String name) throws CannotCreateFileException {
        return this.vfs.createVDir(this, name);
    }

    @Override
    @Nonnull
    public BaseVFile createVFile(@Nonnull String name) throws CannotCreateFileException {
        return this.vfs.createVFile(this, name);
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.vfs.getVDirLocation(this);
    }

    @Nonnull
    public Location getVDirLocation(@Nonnull VPath path) {
        return this.vfs.getVDirLocation(this, path);
    }

    @Nonnull
    public Location getVFileLocation(@Nonnull VPath path) {
        return this.vfs.getVFileLocation(this, path);
    }

    @Nonnull
    public Location getVDirLocation(@Nonnull String name) {
        return this.vfs.getVDirLocation(this, name);
    }

    @Nonnull
    public Location getVFileLocation(@Nonnull String name) {
        return this.vfs.getVFileLocation(this, name);
    }
}

