/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.tracer.probe.MemoryBytesProbe;
import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@HasKeyId
public abstract class HeapAllocationProbe
extends MemoryBytesProbe {
    @Nonnull
    public static final BooleanPropertyId GET_ALLOCATION_SITE = BooleanPropertyId.create("sched.tracer.probe.heap-allocation.site", "Get allocation site information during statistics").addDefaultValue(Boolean.FALSE);
    @Nonnull
    protected static final ThreadLocal<ThreadLocalCounting> alloc = new ThreadLocal<ThreadLocalCounting>(){

        @Override
        protected ThreadLocalCounting initialValue() {
            return new ThreadLocalCounting();
        }
    };
    private static boolean installed = false;

    protected HeapAllocationProbe(@Nonnull String description) {
        super(description, 12);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    public static void ensureInstall() {
        if (!installed) {
            installed = true;
            try {
                Class.forName("com.google.monitoring.runtime.instrumentation.Sampler");
                Instrumentation.install();
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger().log(Level.WARNING, "Allocation instrumenter agent is not specified on the JVM command line (see -javaagent)");
            }
        }
    }

    private static class Instrumentation {
        private Instrumentation() {
        }

        private static void install() {
            Sampler sampler = new Sampler(){
                private int stackDepth = -1;

                public void sampleAllocation(int count, String desc, Object newObj, long size) {
                    Tracer tracer = TracerFactory.getTracer();
                    try {
                        if (tracer.isTracing()) {
                            ThreadLocalCounting tlc = alloc.get();
                            ++tlc.count;
                            tlc.size += size;
                            tracer.registerObject(newObj, size, count, this.getAllocationSite());
                        }
                    }
                    catch (ConfigurationError configurationError) {
                        // empty catch block
                    }
                }

                @CheckForNull
                private StackTraceElement getAllocationSite() {
                    if (this.stackDepth == 0) {
                        return null;
                    }
                    StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                    if (this.stackDepth < 0) {
                        if (ThreadConfig.get(GET_ALLOCATION_SITE).booleanValue()) {
                            this.stackDepth = 0;
                            while (!stack[this.stackDepth++].getClassName().startsWith("com.google.monitoring.runtime")) {
                            }
                            while (stack[this.stackDepth++].getClassName().startsWith("com.google.monitoring.runtime")) {
                            }
                        } else {
                            this.stackDepth = 0;
                        }
                    }
                    return stack[this.stackDepth];
                }
            };
            AllocationRecorder.addSampler((Sampler)sampler);
        }
    }

    public static class ThreadLocalCounting {
        @Nonnegative
        public long count;
        @Nonnegative
        public long size;
    }
}

