/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer;

import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.tracer.ProbeManagerBuilder;
import com.android.sched.util.log.tracer.ProbeManagerCodec;
import com.android.sched.util.log.tracer.filter.EventFilter;
import com.android.sched.util.log.tracer.probe.Probe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@HasKeyId
public class ProbeManager {
    @Nonnull
    private static final PropertyId<ProbeManager> PROBE_MANAGER = PropertyId.create("sched.tracer.probes", "Define which probes use for tracing", new ProbeManagerCodec()).addDefaultValue((ProbeManager)((Object)"event-count,gc-duration,thread-cpu-time"));
    @Nonnull
    public static final ThreadLocal<Boolean> enable = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    @Nonnull
    private final EventFilter[] filters;
    @Nonnull
    private final Probe[] probes;
    @Nonnull
    private final List<Probe> listProbes = new ArrayList<Probe>();
    @Nonnegative
    private final int nb;

    @Nonnull
    public static ProbeManager getProbeManager() {
        return ThreadConfig.get(PROBE_MANAGER);
    }

    ProbeManager(@Nonnull ProbeManagerBuilder builder) {
        Map<Probe, EventFilter> map = builder.getProbes();
        this.nb = map.size();
        this.probes = new Probe[this.nb];
        this.filters = new EventFilter[this.nb];
        this.listProbes.addAll(map.keySet());
        Collections.sort(this.listProbes);
        int idx = 0;
        Iterator<Probe> iterator = this.listProbes.iterator();
        while (iterator.hasNext()) {
            Probe probe;
            this.probes[idx] = probe = iterator.next();
            this.filters[idx] = map.get(probe);
            ++idx;
        }
    }

    @Nonnull
    long[] readAndStart(@Nonnull EventType type) {
        long[] values = new long[this.nb];
        for (int i = this.nb - 1; i >= 0; --i) {
            EventFilter filter = this.filters[i];
            if (filter != null && !filter.isEnabled(type)) continue;
            values[i] = this.probes[i].read();
        }
        this.start();
        return values;
    }

    void start() {
        for (int i = 0; i < this.nb; ++i) {
            this.probes[i].start();
        }
        enable.set(Boolean.TRUE);
    }

    @Nonnull
    long[] stopAndRead(@Nonnull EventType type) {
        this.stop();
        long[] values = new long[this.nb];
        for (int i = 0; i < this.nb; ++i) {
            EventFilter filter = this.filters[i];
            if (filter != null && !filter.isEnabled(type)) continue;
            values[i] = this.probes[i].read();
        }
        return values;
    }

    void stop() {
        enable.set(Boolean.FALSE);
        for (int i = 0; i < this.nb; ++i) {
            this.probes[i].stop();
        }
    }

    @Nonnull
    long[] read(@Nonnull EventType type) {
        long[] values = new long[this.nb];
        for (int i = this.nb - 1; i >= 0; --i) {
            EventFilter filter = this.filters[i];
            if (filter != null && !filter.isEnabled(type)) continue;
            values[i] = this.probes[i].read();
        }
        return values;
    }

    @Nonnegative
    int getIndex(@Nonnull Probe probe) {
        int index = this.listProbes.indexOf(probe);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return index;
    }

    boolean hasFilter(@Nonnull Probe probe) {
        return this.filters[this.getIndex(probe)] != null;
    }

    @CheckForNull
    EventFilter getFilter(@Nonnull Probe probe) {
        return this.filters[this.getIndex(probe)];
    }

    @Nonnull
    List<Probe> getProbes() {
        return this.listProbes;
    }

    public boolean isStarted() {
        return enable.get();
    }
}

