/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log;

import com.android.jack.google.common.collect.Iterators;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.codec.WriterFileCodec;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ReflectFactory;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.ReflectFactoryPropertyId;
import com.android.sched.util.config.id.WriterFilePropertyId;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.EventType;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.ThreadTracerState;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.tracer.AbstractTracer;
import com.android.sched.util.log.tracer.TracerEventType;
import com.android.sched.util.log.tracer.probe.HeapAllocationProbe;
import com.android.sched.util.log.tracer.probe.Probe;
import com.android.sched.util.log.tracer.watcher.ObjectWatcher;
import com.android.sched.util.log.tracer.watcher.WatcherInstaller;
import com.android.sched.util.print.DataModel;
import com.android.sched.util.print.DataModelListAdapter;
import com.android.sched.util.print.DataType;
import com.android.sched.util.print.DataView;
import com.android.sched.util.print.DataViewBuilder;
import com.android.sched.util.print.Printer;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@ImplementationName(iface=Tracer.class, name="stat-only", description="collect statistics without event information")
@HasKeyId
public final class StatisticOnlyTracer
implements Tracer {
    @Nonnull
    private static final ReflectFactoryPropertyId<Printer> PRINTER = ((ReflectFactoryPropertyId)ReflectFactoryPropertyId.create("sched.tracer.format", "Define which format to use", Printer.class).addArgType(PrintWriter.class).addDefaultValue("text")).requiredIf(TracerFactory.TRACER.getClazz().isSubClassOf(StatisticOnlyTracer.class));
    @Nonnull
    public static final WriterFilePropertyId STREAM = WriterFilePropertyId.create("sched.tracer.file", "The file where to print statistics", new WriterFileCodec(FileOrDirectory.Existence.MAY_EXIST).allowStandardOutputOrError().allowCharset()).addDefaultValue("-").requiredIf(TracerFactory.TRACER.getClazz().isSubClassOf(StatisticOnlyTracer.class));
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final SingletonEvent event = new SingletonEvent();
    @Nonnull
    public static final ThreadLocal<Boolean> enable = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    @Nonnull
    private final Map<Class<? extends ObjectWatcher<?>>, WeakHashMap<Object, ObjectWatcher<Object>>> objects = new HashMap();
    @Nonnull
    private final Map<Class<?>, List<Class<? extends ObjectWatcher<?>>>> watchers = new HashMap();
    @Nonnull
    private final Set<Class<?>> notWatched = new HashSet();
    @Nonnull
    private final ReentrantReadWriteLock watcherLock = new ReentrantReadWriteLock();

    public StatisticOnlyTracer() {
        List<WatcherInstaller> watchers = ThreadConfig.get(AbstractTracer.WATCHER_INSTALL);
        if (watchers.size() > 0) {
            for (WatcherInstaller watcher : watchers) {
                watcher.install(this);
            }
            HeapAllocationProbe.ensureInstall();
        }
    }

    @Override
    @Nonnull
    public SingletonEvent open(@Nonnull EventType type) {
        this.event.eventCount.incrementAndGet();
        return this.event;
    }

    @Override
    @Nonnull
    public SingletonEvent open(@Nonnull String name) {
        this.event.eventCount.incrementAndGet();
        return this.event;
    }

    @Override
    @Nonnull
    public ThreadTracerState getThreadState() {
        return ThreadTracerStateImpl.INSTANCE;
    }

    @Override
    public void pushThreadState(@Nonnull ThreadTracerState state) {
    }

    @Override
    public void popThreadState(@Nonnull ThreadTracerState state) {
    }

    @Override
    public boolean isTracing() {
        return enable.get();
    }

    @Override
    @Nonnull
    public EventType getCurrentEventType() {
        return TracerEventType.SINGLETON;
    }

    @Override
    @Nonnull
    public <T extends Statistic> T getStatistic(@Nonnull StatisticId<T> id) {
        return this.event.getStatistic(id);
    }

    @Override
    @Nonnull
    public EventType getDynamicEventType(@Nonnull String name) {
        return TracerEventType.SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <T> void registerWatcher(@Nonnull Class<T> rootWatchedClass, @Nonnull Class<? extends ObjectWatcher<? extends T>> watcherClass) {
        WeakHashMap map = new WeakHashMap();
        this.watcherLock.writeLock().lock();
        try {
            this.objects.put(watcherClass, map);
            List<Class<ObjectWatcher<?>>> list = this.watchers.get(rootWatchedClass);
            if (list == null) {
                list = new ArrayList(1);
                this.watchers.put(rootWatchedClass, list);
            }
            list.add(watcherClass);
            Iterator<Class<?>> iterNotWatched = this.notWatched.iterator();
            while (iterNotWatched.hasNext()) {
                Class<?> watchedClass = iterNotWatched.next();
                if (!rootWatchedClass.isAssignableFrom(watchedClass)) continue;
                this.logger.log(Level.INFO, "Watcher ''{0}'' missed some instances of type ''{1}''", new Object[]{watcherClass.getName(), watchedClass.getName()});
                list = this.watchers.get(watchedClass);
                if (list == null) {
                    list = new ArrayList(1);
                    this.watchers.put(watchedClass, list);
                }
                list.add(watcherClass);
                iterNotWatched.remove();
            }
        }
        finally {
            this.watcherLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObject(@Nonnull Object object, @Nonnegative long size, int count, @CheckForNull StackTraceElement site) {
        enable.set(Boolean.FALSE);
        Class<?> objectClass = object.getClass();
        List<Class<ObjectWatcher<?>>> list = null;
        this.watcherLock.readLock().lock();
        try {
            if (this.notWatched.contains(objectClass)) {
                return;
            }
            list = this.watchers.get(objectClass);
        }
        finally {
            this.watcherLock.readLock().unlock();
        }
        if (list == null) {
            this.watcherLock.writeLock().lock();
            try {
                list = this.watchers.get(objectClass);
                if (list == null) {
                    list = new ArrayList(1);
                    for (Map.Entry entry : this.watchers.entrySet()) {
                        if (!((Class)entry.getKey()).isAssignableFrom(objectClass)) continue;
                        list.addAll((Collection)entry.getValue());
                    }
                }
                if (!list.isEmpty()) {
                    this.watchers.put(objectClass, list);
                } else {
                    this.notWatched.add(objectClass);
                }
            }
            finally {
                this.watcherLock.writeLock().unlock();
            }
        }
        for (Class<ObjectWatcher<?>> clazz : list) {
            try {
                ObjectWatcher<?> watcher = clazz.newInstance();
                if (!watcher.notifyInstantiation(object, size, count, this.getCurrentEventType(), site)) continue;
                WeakHashMap<Object, ObjectWatcher<Object>> weak = this.objects.get(clazz);
                assert (weak != null);
                weak.put(object, watcher);
            }
            catch (InstantiationException e) {
                this.logger.log(Level.WARNING, "Can not instantiate Watcher", e);
            }
            catch (IllegalAccessException e) {
                this.logger.log(Level.WARNING, "Can not instantiate Watcher", e);
            }
        }
    }

    private static class ThreadTracerStateImpl
    implements ThreadTracerState {
        @Nonnull
        public static final ThreadTracerStateImpl INSTANCE = new ThreadTracerStateImpl();

        private ThreadTracerStateImpl() {
        }
    }

    public static class SingletonEvent
    implements Event {
        @Nonnull
        private final AtomicInteger eventCount = new AtomicInteger(0);
        @Nonnull
        private final Map<StatisticId<? extends Statistic>, Statistic> statisticsById = new ConcurrentHashMap<StatisticId<? extends Statistic>, Statistic>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.eventCount.decrementAndGet() == 0) {
                try {
                    enable.set(Boolean.FALSE);
                    DataModelListAdapter<Statistic> report = new DataModelListAdapter<Statistic>(new DataModelListAdapter.Converter<Statistic>(){

                        @Nonnull
                        public StatisticModel apply(@Nonnull Statistic data) {
                            return new StatisticModel(data);
                        }
                    });
                    for (Statistic statistic : this.statisticsById.values()) {
                        if (!statistic.isEnabled()) continue;
                        report.add(statistic);
                    }
                    CustomPrintWriter writer = ThreadConfig.get(STREAM).getPrintWriter();
                    Printer printer = ((Printer)((ReflectFactory)ThreadConfig.get(PRINTER)).create(writer)).addResourceBundles(ResourceBundle.getBundle(Statistic.class.getCanonicalName()), ResourceBundle.getBundle(StatisticOnlyTracer.class.getCanonicalName()));
                    try {
                        printer.print(report);
                    }
                    finally {
                        ((PrintWriter)writer).close();
                    }
                }
                finally {
                    enable.set(Boolean.TRUE);
                }
            }
        }

        @Override
        @Nonnegative
        public long getElapsedValue(@Nonnull Probe probe) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnegative
        public long getStartValue(@Nonnull Probe probe) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public EventType getType() {
            return TracerEventType.SINGLETON;
        }

        @Nonnull
        public String toString() {
            return "Singleton";
        }

        @Nonnull
        public List<Event> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public void adjustElapsedValue(@Nonnull Probe probe, long elapsedValue) {
        }

        @Override
        @Nonnull
        public Collection<Statistic> getStatistics() {
            try {
                enable.set(Boolean.FALSE);
                Collection<Statistic> collection = this.statisticsById.values();
                return collection;
            }
            finally {
                enable.set(Boolean.TRUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public synchronized <T extends Statistic> T getStatistic(@Nonnull StatisticId<T> id) {
            try {
                enable.set(Boolean.FALSE);
                Statistic statistic = this.statisticsById.get(id);
                if (statistic == null) {
                    statistic = id.newInstance();
                    this.statisticsById.put(id, statistic);
                }
                Statistic statistic2 = statistic;
                return (T)statistic2;
            }
            finally {
                enable.set(Boolean.TRUE);
            }
        }
    }

    private static class StatisticModel
    implements DataModel {
        private static final DataView STATISTIC_VIEW = DataViewBuilder.getStructure().addField("name", DataType.STRING).addField("description", DataType.STRING).addField("type", DataType.BUNDLE).addField("value", DataType.STRUCT).build();
        @Nonnull
        private final Statistic statistic;

        public StatisticModel(@Nonnull Statistic statistic) {
            this.statistic = statistic;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.forArray(this.statistic.getId().getName(), this.statistic.getId().getDescription(), this.statistic.getClass().getCanonicalName(), this.statistic);
        }

        @Override
        @Nonnull
        public DataView getDataView() {
            return STATISTIC_VIEW;
        }
    }
}

