/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.location.DirectoryLocation;
import com.android.sched.util.location.FileLocation;
import java.io.File;
import javax.annotation.Nonnull;

public class Files {
    private static final int TEMP_ATTEMPTS = 10000;

    private Files() {
    }

    @Nonnull
    public static File createTempDir(@Nonnull String prefix) throws CannotCreateFileException, CannotChangePermissionException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = prefix + System.currentTimeMillis() + "-";
        DirectoryLocation location = null;
        for (int counter = 0; counter < 10000; ++counter) {
            File tempDir = new File(baseDir, baseName + counter);
            location = new DirectoryLocation(tempDir);
            try {
                Directory.create(tempDir, location);
                FileOrDirectory.unsetPermissions(tempDir, location, 7, FileOrDirectory.ChangePermission.EVERYBODY);
                FileOrDirectory.setPermissions(tempDir, location, 7, FileOrDirectory.ChangePermission.OWNER);
                return tempDir;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
        }
        assert (location != null);
        throw new CannotCreateFileException(location);
    }

    @Nonnull
    public static File createTempFile(@Nonnull String prefix) throws CannotCreateFileException, CannotChangePermissionException {
        return Files.createTempFile(prefix, "");
    }

    @Nonnull
    public static File createTempFile(@Nonnull String prefix, @Nonnull String suffix) throws CannotCreateFileException, CannotChangePermissionException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = prefix + System.currentTimeMillis() + "-";
        FileLocation location = null;
        for (int counter = 0; counter < 10000; ++counter) {
            File tempFile = new File(baseDir, baseName + counter + suffix);
            location = new FileLocation(tempFile);
            try {
                AbstractStreamFile.create(tempFile, location);
                FileOrDirectory.unsetPermissions(tempFile, location, 3, FileOrDirectory.ChangePermission.EVERYBODY);
                FileOrDirectory.setPermissions(tempFile, location, 3, FileOrDirectory.ChangePermission.OWNER);
                return tempFile;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
        }
        assert (location != null);
        throw new CannotCreateFileException(location);
    }
}

