/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.cli;

import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.InputStreamFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.NotFileOrDirectoryException;
import com.android.sched.util.file.SchedIOException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import com.android.sched.util.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class TokenIterator {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private static final Entry NULL = new Entry();
    private static final char DEFAULT_FILE_PREFIX = '@';
    private char filePrefix = (char)64;
    private boolean allowFileRefInArray = true;
    private boolean allowFileRefInFile = false;
    @CheckForNull
    private Directory baseDirectory = null;
    @Nonnull
    private final String[] args;
    private int index = 0;
    @Nonnull
    private Entry next = NULL;
    @Nonnull
    private Entry current = NULL;
    @CheckForNull
    private SchedIOException pending = null;
    private final Sources sources = new Sources();

    public TokenIterator(@Nonnull Location location, String ... args) {
        this.args = (String[])args.clone();
        this.sources.push(location);
    }

    @Nonnull
    public TokenIterator withFilePrefix(char filePrefix) {
        this.filePrefix = filePrefix;
        return this;
    }

    @Nonnull
    public TokenIterator allowFileReferenceInFile() {
        this.allowFileRefInFile = true;
        return this;
    }

    @Nonnull
    public TokenIterator withFileRelativeTo(@Nonnull File directory) throws NotDirectoryException, WrongPermissionException, NoSuchFileException {
        try {
            this.baseDirectory = new Directory(directory.getPath(), null, FileOrDirectory.Existence.MUST_EXIST, 4, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    @Nonnull
    public TokenIterator disallowFileReferenceInArray() {
        this.allowFileRefInArray = false;
        return this;
    }

    public boolean hasNext() {
        if (this.next == NULL) {
            try {
                this.next = this.getNext();
            }
            catch (NoSuchElementException e) {
                return false;
            }
            catch (SchedIOException e) {
                this.pending = e;
            }
        }
        return true;
    }

    @Nonnull
    public String next() throws NoSuchElementException, WrongPermissionException, NoSuchFileException, NotFileOrDirectoryException, CannotReadException {
        this.throwIfPending();
        if (this.next == NULL) {
            try {
                this.current = this.getNext();
            }
            catch (NoSuchElementException e) {
                this.current = NULL;
                throw e;
            }
            catch (SchedIOException e) {
                this.current = NULL;
                this.pending = e;
                this.throwIfPending();
                throw new AssertionError();
            }
        } else {
            this.current = this.next;
            this.next = NULL;
        }
        assert (this.current.value != null);
        return this.current.value;
    }

    @CheckForNull
    public String getToken() throws WrongPermissionException, NoSuchFileException, NotFileOrDirectoryException, CannotReadException {
        this.throwIfPending();
        return this.current.value;
    }

    @CheckForNull
    public Location getLocation() throws WrongPermissionException, NoSuchFileException, NotFileOrDirectoryException, CannotReadException {
        this.throwIfPending();
        return this.current.location;
    }

    private void throwIfPending() throws WrongPermissionException, NoSuchFileException, NotFileOrDirectoryException, CannotReadException {
        if (this.pending != null) {
            if (this.pending instanceof WrongPermissionException) {
                throw (WrongPermissionException)this.pending;
            }
            if (this.pending instanceof NoSuchFileException) {
                throw (NoSuchFileException)this.pending;
            }
            if (this.pending instanceof NotFileOrDirectoryException) {
                throw (NotFileOrDirectoryException)this.pending;
            }
            if (this.pending instanceof CannotReadException) {
                throw (CannotReadException)this.pending;
            }
            throw new AssertionError();
        }
    }

    @Nonnull
    private Entry getNext() throws NoSuchElementException, WrongPermissionException, NoSuchFileException, NotFileException, CannotReadException {
        while (true) {
            StreamTokenizer tokenizer = this.sources.getCurrentTokenizer();
            while (tokenizer != null) {
                try {
                    if (tokenizer.nextToken() != -1) {
                        if (this.allowFileRefInFile && !tokenizer.sval.isEmpty() && tokenizer.sval.charAt(0) == this.filePrefix) {
                            this.sources.push(tokenizer.sval.substring(1));
                            tokenizer = this.sources.getCurrentTokenizer();
                            continue;
                        }
                        return new Entry(tokenizer.sval, new ColumnAndLineLocation(this.sources.getCurrentLocation(), tokenizer.lineno()));
                    }
                }
                catch (IOException e) {
                    try {
                        throw new CannotReadException(this.sources.getCurrentLocation());
                    }
                    catch (Throwable throwable) {
                        this.sources.clear();
                        this.sources.push(new NoLocation());
                        this.index = this.args.length;
                        throw throwable;
                    }
                }
                this.sources.pop();
                tokenizer = this.sources.getCurrentTokenizer();
            }
            if (this.index >= this.args.length) {
                throw new NoSuchElementException();
            }
            if (!this.allowFileRefInArray || this.args[this.index].isEmpty() || this.args[this.index].charAt(0) != this.filePrefix) break;
            this.sources.push(this.args[this.index].substring(1));
            ++this.index;
        }
        return new Entry(this.args[this.index++], this.sources.getCurrentLocation());
    }

    @Nonnull
    protected StreamTokenizer getTokenizer(@Nonnull InputStreamFile file) {
        InputStreamReader reader = new InputStreamReader(file.getInputStream());
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.whitespaceChars(10, 10);
        tokenizer.whitespaceChars(13, 13);
        tokenizer.quoteChar(39);
        tokenizer.quoteChar(34);
        tokenizer.commentChar(35);
        tokenizer.eolIsSignificant(false);
        tokenizer.slashSlashComments(false);
        tokenizer.slashStarComments(false);
        tokenizer.lowerCaseMode(false);
        return tokenizer;
    }

    private static class Entry {
        @CheckForNull
        private final String value;
        @CheckForNull
        private final Location location;

        private Entry() {
            this(null, null);
        }

        private Entry(@CheckForNull String value, @CheckForNull Location location) {
            this.value = value;
            this.location = location;
        }
    }

    private class Sources {
        @Nonnull
        private final Stack<Source> stack = new Stack();

        private Sources() {
        }

        public void push(@Nonnull Location location) {
            this.stack.push(new Source(location));
        }

        public void push(@Nonnull String fileName) throws WrongPermissionException, NoSuchFileException, NotFileException {
            InputStreamFile file = new InputStreamFile(TokenIterator.this.baseDirectory, fileName);
            this.stack.push(new Source(file, TokenIterator.this.getTokenizer(file)));
        }

        public void pop() {
            InputStreamFile file = this.stack.pop().file;
            if (file != null) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Cannot close " + file.getLocation().getDescription());
                }
            }
        }

        public void clear() {
            while (!this.stack.isEmpty()) {
                this.pop();
            }
        }

        @Nonnull
        public Location getCurrentLocation() {
            return this.stack.peek().location;
        }

        @CheckForNull
        public StreamTokenizer getCurrentTokenizer() {
            return this.stack.peek().tokenizer;
        }

        private class Source {
            @CheckForNull
            private final StreamTokenizer tokenizer;
            @Nonnull
            private final Location location;
            @CheckForNull
            private final InputStreamFile file;

            public Source(Location location) {
                this.tokenizer = null;
                this.file = null;
                this.location = location;
            }

            public Source(@Nonnull InputStreamFile file, StreamTokenizer tokenizer) {
                this.tokenizer = tokenizer;
                this.file = file;
                this.location = file.getLocation();
            }
        }
    }
}

