/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.vfs.InputVFS;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

abstract class InputVFSCodec
extends FileOrDirCodec<InputVFS> {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();

    public InputVFSCodec() {
        super(FileOrDirectory.Existence.MUST_EXIST, 1);
        assert ((this.permissions & 4) == 0);
    }

    @Nonnull
    public InputVFSCodec changeOwnerPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.OWNER);
        return this;
    }

    @Nonnull
    public InputVFSCodec changeAllPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.EVERYBODY);
        return this;
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a directory or zip archive (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "zip-or-dir";
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull InputVFS dir) {
    }

    @Override
    @Nonnull
    public InputVFS parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return (InputVFS)this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull InputVFS directory) {
        return directory.getPath();
    }
}

