/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import javax.annotation.Nonnull;

public class DirectoryCodec
extends FileOrDirCodec<Directory> {
    public DirectoryCodec(@Nonnull FileOrDirectory.Existence existence, int permissions) {
        super(existence, permissions);
        assert ((permissions & 4) == 0);
    }

    @Nonnull
    public DirectoryCodec changeOwnerPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.OWNER);
        return this;
    }

    @Nonnull
    public DirectoryCodec changeAllPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.EVERYBODY);
        return this;
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a directory (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "dir";
    }

    @Override
    @Nonnull
    public Directory checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            return new Directory(context.getWorkingDirectory(), string, context.getRunnableHooks(), this.existence, this.permissions, this.change);
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull Directory dir) {
    }

    @Override
    @Nonnull
    public Directory parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Directory directory) {
        return directory.getPath();
    }
}

