/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class FinalizerRunner {
    @Nonnull
    private static final Logger logger = Logger.getLogger(FinalizerRunner.class.getName());
    @Nonnull
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    @Nonnull
    private final List<PhantomReference<Object>> referenceList = new LinkedList<PhantomReference<Object>>();
    @CheckForNull
    private Thread thread;
    @Nonnull
    private final String name;
    private boolean shutDown = false;

    public FinalizerRunner(@Nonnull String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFinalizer(@Nonnull Runnable finalizer, @Nonnull Object watched) {
        List<PhantomReference<Object>> list = this.referenceList;
        synchronized (list) {
            assert (!this.shutDown);
            if (this.thread == null) {
                FinalizerThread finalizerThread = new FinalizerThread(this.name);
                finalizerThread.setDaemon(true);
                this.thread = finalizerThread;
                finalizerThread.start();
            }
            FinalizerReference reference = new FinalizerReference(watched, this.queue, finalizer);
            this.referenceList.add(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<PhantomReference<Object>> list = this.referenceList;
        synchronized (list) {
            this.shutDown = true;
            Thread finalizerThread = this.thread;
            if (finalizerThread != null) {
                finalizerThread.interrupt();
            }
        }
    }

    private static class FinalizerReference
    extends PhantomReference<Object>
    implements Runnable {
        @Nonnull
        private final Runnable finalizer;

        public FinalizerReference(@Nonnull Object referent, @Nonnull ReferenceQueue<Object> queue, @Nonnull Runnable finalizer) {
            super(referent, queue);
            this.finalizer = finalizer;
        }

        @Override
        public void run() {
            this.finalizer.run();
        }

        public String toString() {
            return "Finalizer for " + this.finalizer;
        }
    }

    private class FinalizerThread
    extends Thread {
        private FinalizerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean isRunning = true;
            try {
                while (isRunning) {
                    logger.log(Level.FINE, "Finalizer thread " + this.getName() + " pulling for next deleter");
                    FinalizerReference removedReference = (FinalizerReference)FinalizerRunner.this.queue.remove();
                    List list = FinalizerRunner.this.referenceList;
                    synchronized (list) {
                        boolean removed = FinalizerRunner.this.referenceList.remove(removedReference);
                        assert (removed);
                        if (FinalizerRunner.this.referenceList.isEmpty()) {
                            isRunning = false;
                            FinalizerRunner.this.thread = null;
                        }
                    }
                    removedReference.run();
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.FINE, "Finalizer thread " + this.getName() + " was interrupted");
                FinalizerReference removedReference = (FinalizerReference)FinalizerRunner.this.queue.poll();
                while (removedReference != null) {
                    removedReference.run();
                    removedReference = (FinalizerReference)FinalizerRunner.this.queue.poll();
                }
                this.interrupt();
            }
        }
    }
}

