/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.filter.ComponentFilterManager;
import com.android.sched.item.AbstractItemManager;
import com.android.sched.item.Feature;
import com.android.sched.item.Production;
import com.android.sched.item.TagOrMarkerOrComponent;
import com.android.sched.reflections.CompositeReflectionManager;
import com.android.sched.reflections.ReflectionFactory;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.scheduler.ComponentFilterSet;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.ProductionSet;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.SchedulableManager;
import com.android.sched.scheduler.SchedulableSet;
import com.android.sched.scheduler.TagOrMarkerOrComponentSet;
import com.android.sched.util.sched.ManagedDataListenerFactory;
import javax.annotation.Nonnull;

public class Scheduler {
    @Nonnull
    private final AbstractItemManager featureManager;
    @Nonnull
    private final AbstractItemManager tagOrMarkerOrComponentManager;
    @Nonnull
    private final AbstractItemManager productionManager;
    @Nonnull
    private final ComponentFilterManager filterManager;
    @Nonnull
    private final SchedulableManager schedulableManager;

    public Scheduler(ReflectionManager ... reflextionManagers) {
        this((ReflectionManager)new CompositeReflectionManager(reflextionManagers));
    }

    public Scheduler() {
        this(ReflectionFactory.getManager());
    }

    public Scheduler(@Nonnull ReflectionManager reflectionManager) {
        this.featureManager = AbstractItemManager.createItemManager(reflectionManager, Feature.class);
        this.tagOrMarkerOrComponentManager = AbstractItemManager.createItemManager(reflectionManager, TagOrMarkerOrComponent.class);
        this.productionManager = AbstractItemManager.createItemManager(reflectionManager, Production.class);
        this.filterManager = ComponentFilterManager.createComponentFilterManager(reflectionManager);
        this.schedulableManager = SchedulableManager.getSchedulableManager(this, reflectionManager);
        ManagedDataListenerFactory.getManagedDataListener().notifyNoMoreItemManager();
    }

    @Nonnull
    public SchedulableSet createSchedulableSet() {
        return new SchedulableSet(this.schedulableManager);
    }

    @Nonnull
    public Request createScheduleRequest(@Nonnull SchedulableSet set) {
        Request sr = new Request(this);
        sr.addSchedulables(set);
        return sr;
    }

    @Nonnull
    public Request createScheduleRequest() {
        return new Request(this);
    }

    @Nonnull
    public SchedulableSet getAllSchedulable() {
        return this.schedulableManager.getAllSchedulable(this.schedulableManager);
    }

    @Nonnull
    public FeatureSet createFeatureSet() {
        return new FeatureSet(this.featureManager);
    }

    @Nonnull
    public TagOrMarkerOrComponentSet createTagOrMarkerOrComponentSet() {
        return new TagOrMarkerOrComponentSet(this.tagOrMarkerOrComponentManager);
    }

    @Nonnull
    public ProductionSet createProductionSet() {
        return new ProductionSet(this.productionManager);
    }

    @Nonnull
    public ComponentFilterSet createComponentFilterSet() {
        return new ComponentFilterSet(this.filterManager);
    }

    @Nonnull
    public AbstractItemManager getFeatureManager() {
        return this.featureManager;
    }

    @Nonnull
    public AbstractItemManager getTagOrMarkerOrComponentManager() {
        return this.tagOrMarkerOrComponentManager;
    }

    @Nonnull
    public AbstractItemManager getProductionManager() {
        return this.productionManager;
    }

    @Nonnull
    public ComponentFilterManager getFilterManager() {
        return this.filterManager;
    }

    @Nonnull
    public SchedulableManager getSchedulableManager() {
        return this.schedulableManager;
    }
}

