/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.filter;

import com.android.sched.filter.ComponentFilterManager;
import com.android.sched.filter.ComponentFilterNotConformException;
import com.android.sched.item.Component;
import com.android.sched.item.ManagedConcreteItem;
import com.android.sched.schedulable.ComponentFilter;
import com.android.sched.util.HasDescription;
import com.android.sched.util.Reflect;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.log.LoggerFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class ManagedComponentFilter
extends ManagedConcreteItem
implements HasDescription {
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Class<? extends ComponentFilter<? extends Component>> filter;
    @Nonnull
    private Class<? extends Component> filterOn;

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public ManagedComponentFilter(@Nonnull Class<? extends ComponentFilter<? extends Component>> filter, @Nonnull ComponentFilterManager manager) throws ComponentFilterNotConformException {
        super(filter, manager);
        this.filter = filter;
        this.extractFilterOn(filter);
        this.checkValidity();
    }

    @Nonnull
    public Class<? extends Component> getFilterOn() {
        return this.filterOn;
    }

    @Nonnull
    public Class<? extends ComponentFilter<? extends Component>> getComponentFilter() {
        return this.filter;
    }

    private void checkValidity() throws ComponentFilterNotConformException {
    }

    private void extractFilterOn(@Nonnull Class<? extends ComponentFilter<? extends Component>> cls) {
        for (Type intf : Reflect.getAllGenericInSuperClassOrInterface(cls)) {
            ParameterizedType pt;
            if (!(intf instanceof ParameterizedType) || !ComponentFilter.class.isAssignableFrom((Class)(pt = (ParameterizedType)intf).getRawType())) continue;
            this.filterOn = (Class)pt.getActualTypeArguments()[0];
            return;
        }
        throw new AssertionError();
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(": component filter on ");
        sb.append(this.filterOn.getCanonicalName());
        return new String(sb);
    }
}

