/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.filter;

import com.android.sched.SchedProperties;
import com.android.sched.filter.ComponentFilterNotConformException;
import com.android.sched.filter.ManagedComponentFilter;
import com.android.sched.item.AbstractItemManager;
import com.android.sched.item.Component;
import com.android.sched.item.Item;
import com.android.sched.item.ItemSet;
import com.android.sched.item.Items;
import com.android.sched.item.ManagedItem;
import com.android.sched.item.onlyfor.Default;
import com.android.sched.item.onlyfor.OnlyForType;
import com.android.sched.marker.MarkerNotConformException;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.schedulable.ComponentFilter;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.sched.ManagedDataListener;
import com.android.sched.util.sched.ManagedDataListenerFactory;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ComponentFilterManager
extends AbstractItemManager {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Class<? extends OnlyForType> onlyFor = ThreadConfig.get(SchedProperties.ONLY_FOR);
    private final boolean failedStop = ThreadConfig.get(SchedProperties.FAILED_STOP);
    @Nonnull
    private final ManagedDataListener listener = ManagedDataListenerFactory.getManagedDataListener();

    @Nonnull
    public static ComponentFilterManager createComponentFilterManager(@Nonnull ReflectionManager reflectionManager) {
        return new ComponentFilterManager(reflectionManager);
    }

    protected ComponentFilterManager(@Nonnull ReflectionManager reflectionManager) {
        this.ensureScan(reflectionManager);
    }

    private void registerComponentFilter(@Nonnull Class<? extends ComponentFilter<? extends Component>> filter) throws MarkerNotConformException {
        assert (this.map != null);
        try {
            ManagedComponentFilter mcf = new ManagedComponentFilter(filter, this);
            this.registerManagedItem(mcf);
            logger.log(Level.INFO, "Register {0}", mcf);
        }
        catch (ComponentFilterNotConformException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    private synchronized void ensureScan(@Nonnull ReflectionManager reflectionManager) {
        for (Class<ComponentFilter> filter : reflectionManager.getSubTypesOf(ComponentFilter.class)) {
            try {
                Class<? extends OnlyForType> filterOnlyFor = Items.getOnlyForType(filter);
                if (filterOnlyFor == null || filterOnlyFor == Default.class || filterOnlyFor == this.onlyFor) {
                    if (Modifier.isAbstract(filter.getModifiers()) || filter.isInterface()) continue;
                    this.registerComponentFilter(filter);
                    continue;
                }
                logger.log(Level.INFO, "Filter ''{0}'' ({1}) is ignored because only for {2}", new Object[]{Items.getName(filter), filter.getCanonicalName(), filterOnlyFor.getSimpleName()});
            }
            catch (MarkerNotConformException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                if (!this.failedStop) continue;
                throw e;
            }
        }
        logger.log(Level.INFO, "Register {0} item(s) in {1} integer(s)", new Object[]{this.getItemsCount(), this.getIntegersCount()});
        for (ManagedItem item : this.map.values()) {
            Class<? extends Item> cls = item.getItem();
            for (Class<?> sup : reflectionManager.getSuperTypesOf(cls)) {
                ManagedItem managedSup = (ManagedItem)this.map.get(sup);
                if (managedSup == null) continue;
                managedSup.addComposedOf(item);
            }
        }
        for (ManagedItem item : this.getManagedItems()) {
            item.addComposedOf();
        }
        for (ManagedItem item : this.map.values()) {
            this.listener.notifyNewManagedItem(item);
            if (!logger.isLoggable(Level.FINER)) continue;
            ItemSet<? extends Item> set = new ItemSet<Item>(this);
            set.add(item.getItem());
            logger.log(Level.FINER, "Item {0} is {1}", new Object[]{item, set});
        }
        this.listener.notifyNoMoreManagedItem(this.getType());
    }

    @Override
    @Nonnull
    public Class<? extends Item> getType() {
        return ComponentFilter.class;
    }

    @CheckForNull
    public <T extends Component> ManagedComponentFilter getManagedComponentFilter(@Nonnull Class<? extends ComponentFilter<T>> filter) {
        return (ManagedComponentFilter)this.map.get(filter);
    }
}

