/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.frontend.java;

import com.android.jack.objectweb.asm.Type;
import com.android.jack.objectweb.asm.tree.AnnotationNode;
import com.android.jack.objectweb.asm.tree.ClassNode;
import com.android.jack.objectweb.asm.tree.FieldNode;
import com.android.jack.objectweb.asm.tree.MethodNode;
import com.android.jill.JillException;
import com.android.jill.backend.jayce.JayceWriter;
import com.android.jill.backend.jayce.Token;
import com.android.jill.frontend.java.AsmHelper;
import com.android.jill.frontend.java.JillWriter;
import com.android.jill.frontend.java.RetentionPolicy;
import com.android.jill.frontend.java.SourceInfoWriter;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class AnnotationWriter
extends JillWriter {
    private static final String JAVA_LANG_SYNTHETIC = "Ljava/lang/Synthetic;";

    public AnnotationWriter(@Nonnull JayceWriter writer, @Nonnull SourceInfoWriter sourceInfoWriter) {
        super(writer, sourceInfoWriter);
    }

    public void writeRetentionPolicy(@Nonnull ClassNode cn) throws IOException {
        assert (AsmHelper.isAnnotation(cn));
        boolean retentionAnnotationFound = false;
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode anno : cn.visibleAnnotations) {
                if (!anno.desc.equals(Type.getType(Retention.class).getDescriptor())) continue;
                assert (anno.values.size() == 2);
                assert (anno.values.get(0) instanceof String);
                assert (((String)anno.values.get(0)).equals("value"));
                assert (anno.values.get(1) instanceof String[]);
                retentionAnnotationFound = true;
                String[] enumAccess = (String[])anno.values.get(1);
                assert (enumAccess.length == 2);
                assert (enumAccess[0].equals(Type.getType(java.lang.annotation.RetentionPolicy.class).getDescriptor()));
                if (enumAccess[1].equals(RetentionPolicy.CLASS.toString())) {
                    this.writer.writeRetentionPolicyEnum(RetentionPolicy.CLASS);
                    break;
                }
                if (enumAccess[1].equals(RetentionPolicy.SOURCE.toString())) {
                    this.writer.writeRetentionPolicyEnum(RetentionPolicy.SOURCE);
                    break;
                }
                if (enumAccess[1].equals(RetentionPolicy.RUNTIME.toString())) {
                    this.writer.writeRetentionPolicyEnum(RetentionPolicy.RUNTIME);
                    break;
                }
                throw new JillException("Unknown retention policy.");
            }
        }
        if (!retentionAnnotationFound) {
            this.writer.writeRetentionPolicyEnum(RetentionPolicy.CLASS);
        }
    }

    public void writeAnnotations(@Nonnull ClassNode cn) throws IOException {
        this.writer.writeOpenNodeList();
        this.writeAnnotations(cn.invisibleAnnotations, RetentionPolicy.CLASS);
        this.writeAnnotations(cn.visibleAnnotations, RetentionPolicy.RUNTIME);
        this.writer.writeCloseNodeList();
    }

    public void writeAnnotations(@Nonnull MethodNode mn) throws IOException {
        this.writer.writeOpenNodeList();
        this.writeAnnotations(mn.invisibleAnnotations, RetentionPolicy.CLASS);
        this.writeAnnotations(mn.visibleAnnotations, RetentionPolicy.RUNTIME);
        this.writer.writeCloseNodeList();
    }

    public void writeAnnotations(@Nonnull FieldNode fn) throws IOException {
        this.writer.writeOpenNodeList();
        this.writeAnnotations(fn.invisibleAnnotations, RetentionPolicy.CLASS);
        this.writeAnnotations(fn.visibleAnnotations, RetentionPolicy.RUNTIME);
        this.writer.writeCloseNodeList();
    }

    public void writeAnnotations(@Nonnull MethodNode mn, @Nonnegative int parameterAnnotIdx) throws IOException {
        this.writer.writeOpenNodeList();
        if (mn.invisibleParameterAnnotations != null) {
            this.writeAnnotations(mn.invisibleParameterAnnotations[parameterAnnotIdx], RetentionPolicy.CLASS);
        }
        if (mn.visibleParameterAnnotations != null) {
            this.writeAnnotations(mn.visibleParameterAnnotations[parameterAnnotIdx], RetentionPolicy.RUNTIME);
        }
        this.writer.writeCloseNodeList();
    }

    @Override
    public void writeValue(Object value) throws IOException {
        if (value instanceof String) {
            this.writeValue((String)value);
        } else if (value instanceof Integer) {
            this.writeValue((Integer)value);
        } else if (value instanceof Boolean) {
            this.writeValue((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeValue((Byte)value);
        } else if (value instanceof Character) {
            this.writeValue(((Character)value).charValue());
        } else if (value instanceof Short) {
            this.writeValue((Short)value);
        } else if (value instanceof Float) {
            this.writeValue(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeValue((Double)value);
        } else if (value instanceof Long) {
            this.writeValue((Long)value);
        } else if (value instanceof String[]) {
            this.writeValue((String[])value);
        } else if (value == null) {
            this.writeValue();
        } else if (value instanceof Type) {
            this.writeValue((Type)value);
        } else if (value.getClass().isArray() && value.getClass().getComponentType().isPrimitive()) {
            this.writeValue(this.convertPrimitiveArrayToObject(value));
        } else if (value instanceof List) {
            this.writeValue(((List)value).toArray());
        } else if (value instanceof AnnotationNode) {
            AnnotationNode annotationNode = (AnnotationNode)value;
            assert (!JAVA_LANG_SYNTHETIC.equals(annotationNode.desc));
            this.writeAnnotation(annotationNode, RetentionPolicy.UNKNOWN);
        } else {
            throw new JillException("Not yet supported.");
        }
    }

    private void writeAnnotations(@CheckForNull List<AnnotationNode> annotations, @Nonnull RetentionPolicy retentionPolicy) throws IOException {
        if (annotations != null) {
            for (AnnotationNode anno : annotations) {
                if (JAVA_LANG_SYNTHETIC.equals(anno.desc)) continue;
                this.writeAnnotation(anno, retentionPolicy);
            }
        }
    }

    private void writeAnnotation(@Nonnull AnnotationNode anno, @Nonnull RetentionPolicy retentionPolicy) throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.ANNOTATION);
        this.writer.writeOpen();
        this.writer.writeRetentionPolicyEnum(retentionPolicy);
        this.writer.writeId(anno.desc);
        this.writeNameValuePair(anno.values);
        this.writer.writeOpenNodeList();
        this.writer.writeCloseNodeList();
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }

    private void writeNameValuePair(@CheckForNull List<Object> values) throws IOException {
        this.writer.writeOpenNodeList();
        if (values != null) {
            for (int i = 0; i < values.size(); i += 2) {
                String name = (String)values.get(i);
                Object value = values.get(i + 1);
                this.sourceInfoWriter.writeUnknwonDebugBegin();
                this.writer.writeKeyword(Token.NAME_VALUE_PAIR);
                this.writer.writeOpen();
                this.writer.writeString(name);
                this.writeValue(value);
                this.sourceInfoWriter.writeUnknownDebugEnd();
                this.writer.writeClose();
            }
        }
        this.writer.writeCloseNodeList();
    }

    private void writeValue(@Nonnull String[] value) throws IOException {
        this.sourceInfoWriter.writeUnknwonDebugBegin();
        this.writer.writeKeyword(Token.ENUM_LITERAL);
        this.writer.writeOpen();
        this.writer.writeId(value[0]);
        this.writer.writeString(value[1]);
        this.sourceInfoWriter.writeUnknownDebugEnd();
        this.writer.writeClose();
    }
}

