/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util.graph;

import com.android.jack.Jack;
import com.android.jack.util.graph.GraphException;
import com.android.sched.marker.LocalMarkerManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class GraphNode<N extends GraphNode<N>>
extends LocalMarkerManager {
    @Nonnull
    protected final ArrayList<N> successors;
    @Nonnull
    protected final ArrayList<N> predecessors = new ArrayList();

    public GraphNode(@Nonnegative int successorsCount) {
        this.successors = new ArrayList(successorsCount);
        for (int i = 0; i < successorsCount; ++i) {
            this.successors.add(null);
        }
    }

    protected void setSuccessor(@Nonnegative int index, @Nonnull N successor) {
        if (index < this.successors.size() && this.successors.get(index) != null) {
            throw new GraphException("Successor already set.");
        }
        this.successors.set(index, successor);
        ((GraphNode)successor).predecessors.add(this);
    }

    protected void addSuccessor(@Nonnegative int index, @Nonnull N successor) {
        this.successors.add(index, successor);
        ((GraphNode)successor).predecessors.add(this);
    }

    public void replaceBy(@Nonnull N newNode) {
        for (GraphNode pred : this.predecessors) {
            int index = pred.successors.indexOf(this);
            pred.successors.set(index, newNode);
        }
        ((GraphNode)newNode).predecessors.remove(this);
        ((GraphNode)newNode).predecessors.addAll(this.predecessors);
        this.predecessors.clear();
    }

    @Nonnull
    public abstract List<N> getSuccessors();

    @Nonnull
    protected List<N> getInternalSuccessors() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.successors);
    }

    @Nonnull
    public List<N> getPredecessors() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.predecessors);
    }

    public boolean removePredecessor(@Nonnull N predecessor) {
        return this.predecessors.remove(predecessor);
    }
}

