/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.util.NamingTools;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PackageCodec
implements StringCodec<String> {
    @Override
    @Nonnull
    public String getUsage() {
        return "a java package name (e.g. com.android)";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "package";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String parseString(@Nonnull CodecContext context, @Nonnull String string) {
        return string;
    }

    @Override
    @CheckForNull
    public String checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        if (!NamingTools.isPackageSourceName(string)) {
            throw new ParsingException("The value must be " + this.getUsage() + " but is '" + string + "'");
        }
        return string;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull String data) throws CheckingException {
        if (!NamingTools.isPackageSourceName(data)) {
            throw new CheckingException("The value must be " + this.getUsage() + " but is '" + data + "'");
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull String name) {
        return name;
    }
}

