/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.analysis.UsedVariableMarker;
import com.android.jack.analysis.dfa.reachingdefs.ReachingDefsMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVariableRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class OptimizationTools {
    @Nonnull
    public static List<DefinitionMarker> getReachingDefs(@Nonnull BasicBlock bb) {
        ReachingDefsMarker rdm = bb.getMarker(ReachingDefsMarker.class);
        assert (rdm != null);
        return rdm.getReachingDefs();
    }

    @Nonnull
    public static List<DefinitionMarker> getReachingDefs(@Nonnull BasicBlock bb, @Nonnull JVariable var) {
        ArrayList<DefinitionMarker> reachingDefs = new ArrayList<DefinitionMarker>();
        for (DefinitionMarker reachingDef : OptimizationTools.getReachingDefs(bb)) {
            if (reachingDef.getDefinedVariable() != var) continue;
            reachingDefs.add(reachingDef);
        }
        return reachingDefs;
    }

    @Nonnull
    public static List<DefinitionMarker> getUsedDefinitions(@Nonnull JVariableRef varRef) {
        UseDefsMarker udm = varRef.getMarker(UseDefsMarker.class);
        assert (udm != null);
        return udm.getDefs();
    }

    @Nonnull
    public static List<JVariableRef> getUsedVariables(@Nonnull JStatement stmt) {
        UsedVariableMarker markerOfVarsUsedBys1 = stmt.getMarker(UsedVariableMarker.class);
        if (markerOfVarsUsedBys1 != null) {
            return markerOfVarsUsedBys1.getUsedVariables();
        }
        return Collections.emptyList();
    }
}

