/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.util;

import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.stream.ByteStreamSucker;
import com.android.sched.util.stream.CharacterStreamSucker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ExecuteFile {
    @Nonnull
    private final String[] cmdLine;
    @CheckForNull
    private File workDir;
    @CheckForNull
    private InputStream inStream;
    @CheckForNull
    private OutputStream outStream;
    @CheckForNull
    private OutputStream errStream;
    private boolean verbose;
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    public void setErr(@Nonnull OutputStream stream) {
        this.errStream = stream;
    }

    public void setOut(@Nonnull OutputStream stream) {
        this.outStream = stream;
    }

    public void setIn(@Nonnull InputStream stream) {
        this.inStream = stream;
    }

    public void setWorkingDir(@Nonnull File dir, boolean create) throws IOException {
        if (!dir.isDirectory()) {
            if (create && !dir.exists()) {
                if (!dir.mkdirs()) {
                    throw new IOException("Directory creation failed");
                }
            } else {
                throw new FileNotFoundException(dir.getPath() + " is not a directory");
            }
        }
        this.workDir = dir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public ExecuteFile(@Nonnull File exec, @Nonnull String[] args) {
        this.cmdLine = new String[args.length + 1];
        System.arraycopy(args, 0, this.cmdLine, 1, args.length);
        this.cmdLine[0] = exec.getPath();
    }

    public ExecuteFile(@Nonnull String exec, @Nonnull String[] args) {
        this.cmdLine = new String[args.length + 1];
        System.arraycopy(args, 0, this.cmdLine, 1, args.length);
        this.cmdLine[0] = exec;
    }

    public ExecuteFile(@Nonnull File exec) {
        this.cmdLine = new String[1];
        this.cmdLine[0] = exec.getPath();
    }

    public ExecuteFile(@Nonnull String[] cmdLine) {
        this.cmdLine = (String[])cmdLine.clone();
    }

    public ExecuteFile(@Nonnull String cmdLine) throws IOException {
        StringReader reader = new StringReader(cmdLine);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(32, 32);
        tokenizer.wordChars(33, 122);
        tokenizer.quoteChar(39);
        tokenizer.quoteChar(34);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.nextToken() != -1) {
            String token = tokenizer.sval;
            if (token == null) continue;
            tokens.add(token);
        }
        this.cmdLine = tokens.toArray(new String[0]);
    }

    public int run() throws Exception {
        OutputStream localErrStream;
        Process proc = null;
        Thread suckOut = null;
        Thread suckErr = null;
        Thread suckIn = null;
        StringBuilder cmdLineBuilder = new StringBuilder();
        for (String arg : this.cmdLine) {
            cmdLineBuilder.append(arg).append(' ');
        }
        if (this.verbose) {
            PrintStream printStream = this.outStream instanceof PrintStream ? (PrintStream)this.outStream : System.out;
            if (printStream != null) {
                printStream.println(cmdLineBuilder);
            }
        } else {
            logger.log(Level.INFO, "Execute: {0}", cmdLineBuilder);
        }
        proc = Runtime.getRuntime().exec(this.cmdLine, null, this.workDir);
        InputStream localInStream = this.inStream;
        if (localInStream != null) {
            suckIn = new Thread(new ThreadByteStreamSucker(localInStream, proc.getOutputStream()));
        } else {
            proc.getOutputStream().close();
        }
        OutputStream localOutStream = this.outStream;
        if (localOutStream != null) {
            suckOut = localOutStream instanceof PrintStream ? new Thread(new ThreadCharacterStreamSucker(proc.getInputStream(), (PrintStream)localOutStream)) : new Thread(new ThreadByteStreamSucker(proc.getInputStream(), localOutStream));
        }
        if ((localErrStream = this.errStream) != null) {
            suckErr = localErrStream instanceof PrintStream ? new Thread(new ThreadCharacterStreamSucker(proc.getErrorStream(), (PrintStream)localErrStream)) : new Thread(new ThreadByteStreamSucker(proc.getErrorStream(), localErrStream));
        }
        if (suckIn != null) {
            suckIn.start();
        }
        if (suckOut != null) {
            suckOut.start();
        }
        if (suckErr != null) {
            suckErr.start();
        }
        proc.waitFor();
        if (suckIn != null) {
            suckIn.join();
        }
        if (suckOut != null) {
            suckOut.join();
        }
        if (suckErr != null) {
            suckErr.join();
        }
        int ret = proc.exitValue();
        proc.destroy();
        return ret;
    }

    private static class ThreadCharacterStreamSucker
    extends CharacterStreamSucker
    implements Runnable {
        public ThreadCharacterStreamSucker(@Nonnull InputStream is, @Nonnull PrintStream ps) {
            super(is, ps);
        }

        @Override
        public void run() {
            try {
                this.suck();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ThreadByteStreamSucker
    extends ByteStreamSucker
    implements Runnable {
        public ThreadByteStreamSucker(@Nonnull InputStream is, @Nonnull OutputStream os) {
            super(is, os);
        }

        @Override
        public void run() {
            try {
                this.suck();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

