/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.operators;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.operators.AbstractCrossover;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ListOrderCrossover<T>
extends AbstractCrossover<List<T>> {
    public ListOrderCrossover() {
        this(Probability.ONE);
    }

    public ListOrderCrossover(Probability crossoverProbability) {
        super(2, crossoverProbability);
    }

    public ListOrderCrossover(NumberGenerator<Probability> crossoverProbabilityVariable) {
        super(new ConstantGenerator<Integer>(2), crossoverProbabilityVariable);
    }

    @Override
    protected List<List<T>> mate(List<T> parent1, List<T> parent2, int numberOfCrossoverPoints, Random rng) {
        assert (numberOfCrossoverPoints == 2) : "Expected number of cross-over points to be 2.";
        if (parent1.size() != parent2.size()) {
            throw new IllegalArgumentException("Cannot perform cross-over with different length parents.");
        }
        ArrayList<T> offspring1 = new ArrayList<T>(parent1);
        ArrayList<T> offspring2 = new ArrayList<T>(parent2);
        int point1 = rng.nextInt(parent1.size());
        int point2 = rng.nextInt(parent1.size());
        int length = point2 - point1;
        if (length < 0) {
            length += parent1.size();
        }
        HashMap mapping1 = new HashMap(length * 2);
        HashMap mapping2 = new HashMap(length * 2);
        for (int i = 0; i < length; ++i) {
            int index = (i + point1) % parent1.size();
            Object item1 = offspring1.get(index);
            Object item2 = offspring2.get(index);
            offspring1.set(index, item2);
            offspring2.set(index, item1);
            mapping1.put(item1, item2);
            mapping2.put(item2, item1);
        }
        this.checkUnmappedElements(offspring1, mapping2, point1, point2);
        this.checkUnmappedElements(offspring2, mapping1, point1, point2);
        ArrayList<List<T>> result = new ArrayList<List<T>>(2);
        result.add(offspring1);
        result.add(offspring2);
        return result;
    }

    private void checkUnmappedElements(List<T> offspring, Map<T, T> mapping, int mappingStart, int mappingEnd) {
        for (int i = 0; i < offspring.size(); ++i) {
            if (this.isInsideMappedRegion(i, mappingStart, mappingEnd)) continue;
            T mapped = offspring.get(i);
            while (mapping.containsKey(mapped)) {
                mapped = mapping.get(mapped);
            }
            offspring.set(i, mapped);
        }
    }

    private boolean isInsideMappedRegion(int position, int startPoint, int endPoint) {
        boolean enclosed = position < endPoint && position >= startPoint;
        boolean wrapAround = startPoint > endPoint && (position >= startPoint || position < endPoint);
        return enclosed || wrapAround;
    }
}

