/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.operators;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class ListInversion<T>
implements EvolutionaryOperator<List<T>> {
    private final NumberGenerator<Probability> inversionProbability;

    public ListInversion(Probability inversionProbability) {
        this(new ConstantGenerator<Probability>(inversionProbability));
    }

    public ListInversion(NumberGenerator<Probability> inversionProbability) {
        this.inversionProbability = inversionProbability;
    }

    @Override
    public List<List<T>> apply(List<List<T>> selectedCandidates, Random rng) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(selectedCandidates.size());
        for (List<T> candidate : selectedCandidates) {
            if (this.inversionProbability.nextValue().nextEvent(rng)) {
                int offset;
                ArrayList<T> newCandidate = new ArrayList<T>(candidate);
                int length = newCandidate.size();
                int start = rng.nextInt(length);
                int end = (start + (offset = 2 + rng.nextInt(length - 2))) % length;
                int segmentLength = end - start;
                if (segmentLength < 0) {
                    segmentLength += length;
                }
                for (int i = 0; i < segmentLength / 2; ++i) {
                    Collections.swap(newCandidate, (start + i) % length, (end - i + length) % length);
                }
                result.add(newCandidate);
                continue;
            }
            result.add(candidate);
        }
        return result;
    }
}

